/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.handler;

import java.util.List;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public interface ChainOfResponsibility<X, R> {
    public R handle(X var1);

    public static <X, R> ChainOfResponsibility<X, R> of(final List<? extends Handler<? super X, R>> chainOfHandlers) {
        return new ChainOfResponsibility<X, R>(){

            @Override
            public R handle(X request) {
                return chainOfHandlers.stream().filter(h -> h.isHandling(request)).findFirst().orElseThrow(() -> _Exceptions.noSuchElement("no handler found for request %s", request)).handle(request);
            }
        };
    }

    public static <X, R> ChainOfResponsibility<X, R> named(final String name, final List<? extends Handler<? super X, R>> chainOfHandlers) {
        return new ChainOfResponsibility<X, R>(){

            @Override
            public R handle(X request) {
                return chainOfHandlers.stream().filter(h -> h.isHandling(request)).findFirst().orElseThrow(() -> _Exceptions.noSuchElement("no %s handler found for request %s", name, request)).handle(request);
            }
        };
    }

    public static interface Handler<X, R> {
        public boolean isHandling(X var1);

        public R handle(X var1);
    }
}

