/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.util.Optional;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public final class _Casts {
    private _Casts() {
    }

    public static <T> T uncheckedCast(@Nullable Object obj) {
        return (T)obj;
    }

    public static <T> Optional<T> castTo(@NonNull Class<T> cls, @Nullable Object value) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (value == null) {
            return Optional.empty();
        }
        if (cls.isAssignableFrom(value.getClass())) {
            return Optional.of(cls.cast(value));
        }
        return Optional.empty();
    }

    @Nullable
    public static <T> T castToOrElseNull(@Nullable Object value, @NonNull Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        if (cls.isAssignableFrom(value.getClass())) {
            return cls.cast(value);
        }
        return null;
    }

    public static <T, R, U, V> R castThenApply(@Nullable U left, @Nullable V right, @NonNull Class<T> cls, BiFunction<T, T, R> onBothCast, BiFunction<T, V, R> onLeftCast, BiFunction<U, T, R> onRightCast, BiFunction<U, V, R> onNonCast) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        Object left_casted = null;
        Object right_casted = null;
        boolean left_not_casted = false;
        boolean right_not_casted = false;
        if (left == null) {
            left_casted = null;
        } else if (cls.isAssignableFrom(left.getClass())) {
            left_casted = cls.cast(left);
        } else {
            left_not_casted = true;
        }
        if (right == null) {
            right_casted = null;
        } else if (cls.isAssignableFrom(right.getClass())) {
            right_casted = cls.cast(right);
        } else {
            right_not_casted = true;
        }
        if (left_not_casted && right_not_casted) {
            return onNonCast.apply(left, right);
        }
        if (!left_not_casted && !right_not_casted) {
            return onBothCast.apply(left_casted, right_casted);
        }
        if (left_not_casted) {
            return onRightCast.apply(left, right_casted);
        }
        return onLeftCast.apply(left_casted, right);
    }
}

