/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public class _Either<L, R>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final L left;
    private final R right;

    public static <L, R> _Either<L, R> left(@NonNull L left) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        return new _Either<L, Object>(left, null);
    }

    public static <L, R> _Either<L, R> right(@NonNull R right) {
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new _Either<Object, R>(null, right);
    }

    public final Optional<L> left() {
        return Optional.ofNullable(this.left);
    }

    public final Optional<R> right() {
        return Optional.ofNullable(this.right);
    }

    public final L leftIfAny() {
        return this.left;
    }

    public final R rightIfAny() {
        return this.right;
    }

    public final boolean isLeft() {
        return this.left != null;
    }

    public final boolean isRight() {
        return this.right != null;
    }

    public final <T> _Either<T, R> mapLeft(@NonNull Function<L, T> leftMapper) {
        if (leftMapper == null) {
            throw new NullPointerException("leftMapper is marked non-null but is null");
        }
        return this.isLeft() ? _Either.left(leftMapper.apply(this.left)) : _Either.right(this.right);
    }

    public final <T> _Either<L, T> mapRight(@NonNull Function<R, T> rightMapper) {
        if (rightMapper == null) {
            throw new NullPointerException("rightMapper is marked non-null but is null");
        }
        return this.isLeft() ? _Either.left(this.left) : _Either.right(rightMapper.apply(this.right));
    }

    public final <X, Y> _Either<X, Y> map(@NonNull Function<L, X> leftMapper, @NonNull Function<R, Y> rightMapper) {
        if (leftMapper == null) {
            throw new NullPointerException("leftMapper is marked non-null but is null");
        }
        if (rightMapper == null) {
            throw new NullPointerException("rightMapper is marked non-null but is null");
        }
        return this.isLeft() ? _Either.left(leftMapper.apply(this.left)) : _Either.right(rightMapper.apply(this.right));
    }

    public final _Either<L, R> mapIfLeft(@NonNull Function<L, _Either<L, R>> leftRemapper) {
        if (leftRemapper == null) {
            throw new NullPointerException("leftRemapper is marked non-null but is null");
        }
        return this.isLeft() ? leftRemapper.apply(this.left) : this;
    }

    public final _Either<L, R> mapIfRight(@NonNull Function<R, _Either<L, R>> rightRemapper) {
        if (rightRemapper == null) {
            throw new NullPointerException("rightRemapper is marked non-null but is null");
        }
        return this.isLeft() ? this : rightRemapper.apply(this.right);
    }

    public final <T> T fold(@NonNull BiFunction<L, R, T> biMapper) {
        if (biMapper == null) {
            throw new NullPointerException("biMapper is marked non-null but is null");
        }
        return biMapper.apply(this.left, this.right);
    }

    public final <T> T fold(@NonNull Function<L, T> leftMapper, @NonNull Function<R, T> rightMapper) {
        if (leftMapper == null) {
            throw new NullPointerException("leftMapper is marked non-null but is null");
        }
        if (rightMapper == null) {
            throw new NullPointerException("rightMapper is marked non-null but is null");
        }
        return this.isLeft() ? leftMapper.apply(this.left) : rightMapper.apply(this.right);
    }

    public final void accept(Consumer<L> leftConsumer, Consumer<R> rightConsumer) {
        if (this.isLeft()) {
            leftConsumer.accept(this.left);
        } else {
            rightConsumer.accept(this.right);
        }
    }

    protected _Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public String toString() {
        return "_Either(left=" + this.left + ", right=" + this.right + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof _Either)) {
            return false;
        }
        _Either other = (_Either)o;
        if (!other.canEqual(this)) {
            return false;
        }
        L this$left = this.left;
        L other$left = other.left;
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        R this$right = this.right;
        R other$right = other.right;
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof _Either;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        L $left = this.left;
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        R $right = this.right;
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }
}

