/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public class _Files {
    public static Set<File> searchFiles(File dir, Predicate<File> dirFilter, Predicate<File> fileFilter) throws IOException {
        HashSet<File> fileList = new HashSet<File>();
        _Files.searchFiles(dir, dirFilter, fileFilter, fileList::add);
        return fileList;
    }

    public static void searchFiles(File dir, Predicate<File> dirFilter, Predicate<File> fileFilter, Consumer<File> onFileFound) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir.toPath());){
            for (Path path : stream) {
                File file = path.toFile();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (!dirFilter.test(file)) continue;
                    _Files.searchFiles(file, dirFilter, fileFilter, onFileFound);
                    continue;
                }
                if (!fileFilter.test(file)) continue;
                onFileFound.accept(file);
            }
        }
    }

    public static Optional<String> canonicalPath(@Nullable File file) {
        if (file == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(file.getCanonicalPath());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String toRelativePath(@NonNull String commonPath, @NonNull String absolutePath) {
        if (commonPath == null) {
            throw new NullPointerException("commonPath is marked non-null but is null");
        }
        if (absolutePath == null) {
            throw new NullPointerException("absolutePath is marked non-null but is null");
        }
        if (absolutePath.startsWith(commonPath)) {
            return absolutePath.substring(commonPath.length());
        }
        return absolutePath;
    }

    public static void deleteFile(@Nullable File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return;
        }
        Files.delete(file.toPath());
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                _Files.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }
}

