/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.util.Optional;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.exceptions._Exceptions;

final class _Lazy_Simple<T>
implements _Lazy<T> {
    private final Supplier<? extends T> supplier;
    private T value;
    private boolean memoized;
    private boolean getting;

    _Lazy_Simple(@NonNull Supplier<? extends T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.supplier = supplier;
    }

    @Override
    public boolean isMemoized() {
        this.guardAgainstRecursiveCall();
        return this.memoized;
    }

    @Override
    public void clear() {
        this.guardAgainstRecursiveCall();
        this.memoized = false;
        this.value = null;
    }

    @Override
    public T get() {
        if (this.memoized) {
            return this.value;
        }
        this.guardAgainstRecursiveCall();
        this.getting = true;
        this.value = this.supplier.get();
        this.getting = false;
        this.memoized = true;
        return this.value;
    }

    @Override
    public Optional<T> getMemoized() {
        this.guardAgainstRecursiveCall();
        return Optional.ofNullable(this.value);
    }

    @Override
    public void set(T value) {
        if (this.memoized) {
            throw _Exceptions.illegalState("cannot set value '%s' on Lazy that has already memoized a value", "" + value);
        }
        this.guardAgainstRecursiveCall();
        this.memoized = true;
        this.value = value;
    }

    private final void guardAgainstRecursiveCall() {
        if (this.getting) {
            throw _Exceptions.illegalState("recursive call of lazy getter detected", new Object[0]);
        }
    }
}

