/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings_FastSplit;
import org.apache.isis.commons.internal.base._Strings_HtmlEscaper;
import org.apache.isis.commons.internal.base._Strings_KeyValuePair;
import org.apache.isis.commons.internal.base._Strings_NaturalNames;
import org.apache.isis.commons.internal.base._Strings_SplitIterator;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.functions._Predicates;
import org.springframework.lang.Nullable;

public final class _Strings {
    public static final String[] emptyArray = new String[0];
    public static final StringOperator asLowerDashed = _Strings.operator().andThen(_Strings::lower).andThen(s -> _Strings.condenseWhitespaces(s, "-"));
    public static final StringOperator asNormalized = _Strings.operator().andThen(s -> _Strings.condenseWhitespaces(s, " "));
    public static final StringOperator asNaturalName2 = _Strings.operator().andThen(s -> _Strings_NaturalNames.naturalName2(s, true));

    private _Strings() {
    }

    public static KeyValuePair pair(String key, String value) {
        return _Strings_KeyValuePair.of(key, value);
    }

    public static Optional<KeyValuePair> parseKeyValuePair(@Nullable String keyValueLiteral, char separator) {
        return _Strings_KeyValuePair.parse(keyValueLiteral, separator);
    }

    public static String of(int length, char c) {
        if (length <= 0) {
            return "";
        }
        char[] chars = new char[length];
        Arrays.fill(chars, c);
        return String.valueOf(chars);
    }

    public static int compareNullsFirst(@Nullable String a, @Nullable String b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static int compareNullsLast(@Nullable String a, @Nullable String b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return a.compareTo(b);
    }

    public static boolean isEmpty(@Nullable CharSequence x) {
        return x == null || x.length() == 0;
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence x) {
        return x == null || x.length() == 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence x) {
        return x != null && x.length() != 0;
    }

    public static Optional<String> nonEmpty(@Nullable CharSequence x) {
        return _Strings.isEmpty(x) ? Optional.empty() : Optional.of(x.toString());
    }

    @Nullable
    public static String emptyToNull(@Nullable String input) {
        if (_Strings.isEmpty(input)) {
            return null;
        }
        return input;
    }

    @Nullable
    public static String blankToNullOrTrim(@Nullable String input) {
        if (_Strings.isEmpty(input)) {
            return null;
        }
        return input.isBlank() ? null : input.trim();
    }

    public static String nullToEmpty(@Nullable String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public static String trim(@Nullable String input) {
        return _With.mapIfPresentElse(input, String::trim, null);
    }

    public static String lower(@Nullable String input) {
        return _With.mapIfPresentElse(input, String::toLowerCase, null);
    }

    public static String upper(@Nullable String input) {
        return _With.mapIfPresentElse(input, String::toUpperCase, null);
    }

    public static String capitalize(@Nullable String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        if (input.length() == 1) {
            return input.toUpperCase();
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    public static String decapitalize(@Nullable String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        if (input.length() == 1) {
            return input.toLowerCase();
        }
        return Character.toLowerCase(input.charAt(0)) + input.substring(1);
    }

    public static String htmlEscape(String source) {
        return _Strings_HtmlEscaper.htmlEscape(source);
    }

    public static String prefix(@Nullable String input, @NonNull String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (input == null) {
            return null;
        }
        if (input.startsWith(prefix)) {
            return input;
        }
        return prefix + input;
    }

    public static String suffix(@Nullable String input, @NonNull String suffix) {
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (input == null) {
            return null;
        }
        if (input.endsWith(suffix)) {
            return input;
        }
        return input + suffix;
    }

    public static String combineWithDelimiter(@Nullable String left, @Nullable String right, String delimiter) {
        _With.requiresNotEmpty(delimiter, "pathDelimiter");
        if (_Strings.isNullOrEmpty(left) && _Strings.isNullOrEmpty(right)) {
            return "";
        }
        if (_Strings.isNullOrEmpty(left)) {
            return right;
        }
        if (_Strings.isNullOrEmpty(right)) {
            return left;
        }
        if (left.endsWith(delimiter) || right.startsWith(delimiter)) {
            return left + right;
        }
        return left + delimiter + right;
    }

    public static String padStart(@Nullable String str, int minLength, char c) {
        if (minLength <= 0) {
            return str;
        }
        int len = _NullSafe.size(str);
        if (len >= minLength) {
            return str;
        }
        int fillCount = minLength - len;
        return _Strings.of(fillCount, c) + _Strings.nullToEmpty(str);
    }

    public static String padEnd(@Nullable String str, int minLength, char c) {
        if (minLength <= 0) {
            return str;
        }
        int len = _NullSafe.size(str);
        if (len >= minLength) {
            return str;
        }
        int fillCount = minLength - len;
        return _Strings.nullToEmpty(str) + _Strings.of(fillCount, c);
    }

    public static Stream<String> splitThenStream(@Nullable String input, String separator) {
        if (_Strings.isEmpty(separator)) {
            throw new IllegalArgumentException("a non empty separator is required");
        }
        if (_Strings.isEmpty(input)) {
            return Stream.of(new String[0]);
        }
        if (!input.contains(separator)) {
            return Stream.of(input);
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(_Strings_SplitIterator.splitIterator(input, separator), 16), false);
    }

    public static Stream<String> splitThenStream(@Nullable CharSequence input, @NonNull Pattern delimiterPattern) {
        if (delimiterPattern == null) {
            throw new NullPointerException("delimiterPattern is marked non-null but is null");
        }
        if (_Strings.isEmpty(input)) {
            return Stream.of(new String[0]);
        }
        return delimiterPattern.splitAsStream(input);
    }

    public static <T> Optional<T> splitThenApplyRequireNonEmpty(@Nullable String input, String separator, BiFunction<String, String, T> onNonEmptySplit) {
        if (_Strings.isEmpty(input)) {
            return Optional.empty();
        }
        int p = input.indexOf(separator);
        if (p < 1) {
            return Optional.empty();
        }
        int q = p + separator.length();
        if (q == input.length()) {
            return Optional.empty();
        }
        return Optional.ofNullable(onNonEmptySplit.apply(input.substring(0, p), input.substring(q)));
    }

    public static void splitThenAccept(@Nullable String input, String separator, BiConsumer<String, String> onNonEmptySplit, Consumer<String> onNonEmptyLhs, Consumer<String> onNonEmptyRhs) {
        _Strings_FastSplit.splitThenAccept(input, separator, onNonEmptySplit, onNonEmptyLhs, onNonEmptyRhs);
    }

    public static void splitThenAcceptEmptyAsNull(@Nullable String input, String separator, BiConsumer<String, String> onSplit) {
        _Strings_FastSplit.splitThenAccept(input, separator, onSplit, lhs -> onSplit.accept((String)lhs, (String)null), rhs -> onSplit.accept((String)null, (String)rhs));
    }

    public static Stream<String> grep(@Nullable String input, @Nullable Predicate<String> matcher) {
        matcher = matcher != null ? matcher : _Predicates.alwaysTrue();
        return _Strings.splitThenStream(input, "\n").filter(_Strings::isNotEmpty).filter(matcher).map(s -> s.replace("\r", ""));
    }

    public static Stream<String> grep(@Nullable String input, @Nullable String contains) {
        Predicate<String> matcher = contains != null ? line -> line.contains(contains) : _Predicates.alwaysTrue();
        return _Strings.grep(input, matcher);
    }

    public static String condenseWhitespaces(@Nullable String input, @NonNull String replacement) {
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return _With.mapIfPresentElse(input, __ -> input.replaceAll("\\s+", replacement), null);
    }

    public static String ellipsifyAtStart(@Nullable CharSequence input, int maxLength, @NonNull CharSequence ellipsis) {
        if (ellipsis == null) {
            throw new NullPointerException("ellipsis is marked non-null but is null");
        }
        if (input == null) {
            return "";
        }
        if (input.length() <= maxLength) {
            return input.toString();
        }
        int trimmedLength = maxLength - ellipsis.length();
        int end = input.length();
        int start = end - trimmedLength;
        return String.join((CharSequence)"", ellipsis, input.subSequence(start, end));
    }

    public static String ellipsifyAtEnd(@Nullable CharSequence input, int maxLength, @NonNull CharSequence ellipsis) {
        if (ellipsis == null) {
            throw new NullPointerException("ellipsis is marked non-null but is null");
        }
        if (input == null) {
            return "";
        }
        if (input.length() <= maxLength) {
            return input.toString();
        }
        int trimmedLength = maxLength - ellipsis.length();
        return String.join((CharSequence)"", input.subSequence(0, trimmedLength), ellipsis);
    }

    public static String read(@Nullable InputStream input, @NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (input == null) {
            return "";
        }
        try (Scanner scanner = new Scanner(input, charset.name());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    public static String readFromResource(@NonNull Class<?> resourceLocation, @NonNull String resourceName, @NonNull Charset charset) {
        String string;
        block11: {
            if (resourceLocation == null) {
                throw new NullPointerException("resourceLocation is marked non-null but is null");
            }
            if (resourceName == null) {
                throw new NullPointerException("resourceName is marked non-null but is null");
            }
            if (charset == null) {
                throw new NullPointerException("charset is marked non-null but is null");
            }
            InputStream input = resourceLocation.getResourceAsStream(resourceName);
            try {
                string = _Strings.read(input, charset);
                if (input == null) break block11;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            input.close();
        }
        return string;
    }

    public static String print(@NonNull Consumer<PrintStream> printer, @NonNull Charset charset) {
        if (printer == null) {
            throw new NullPointerException("printer is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream((OutputStream)baos, true, charset);){
            printer.accept(ps);
        }
        return baos.toString(charset);
    }

    public static String printUtf8(@NonNull Consumer<PrintStream> printer) {
        if (printer == null) {
            throw new NullPointerException("printer is marked non-null but is null");
        }
        return _Strings.print(printer, StandardCharsets.UTF_8);
    }

    public static final byte[] toBytes(@Nullable String str, @NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return _With.mapIfPresentElse(str, __ -> str.getBytes(charset), null);
    }

    public static final String ofBytes(@Nullable byte[] bytes, @NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return _With.mapIfPresentElse(bytes, __ -> new String(bytes, charset), null);
    }

    public static final String convert(@Nullable String input, @NonNull _Bytes.BytesOperator converter, @NonNull Charset charset) {
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return _With.mapIfPresentElse(input, __ -> _Strings.ofBytes(converter.apply(_Strings.toBytes(input, charset)), charset), null);
    }

    public static StringOperator operator() {
        return new StringOperator(UnaryOperator.identity());
    }

    public static final String asFileNameWithExtension(@NonNull String fileName, @NonNull String fileExtension) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (fileExtension == null) {
            throw new NullPointerException("fileExtension is marked non-null but is null");
        }
        return _Strings.suffix(fileName, _Strings.prefix(fileExtension, "."));
    }

    public static final String asPrefixDropped(@Nullable String name) {
        return _Strings.isNotEmpty(name) ? _Strings.streamCharacters(name).dropWhile(c -> c.charValue() != '_' && Character.isLowerCase(c.charValue())).collect(_Strings.joiningCharacters()) : name;
    }

    public static Stream<String> splitThenStreamTrimmed(@Nullable String input, String separator) {
        return _Strings.splitThenStream(input, separator).map(String::trim).filter(_Predicates.not(String::isEmpty));
    }

    public static Stream<String> splitThenStreamTrimmed(@Nullable CharSequence input, Pattern delimiterPattern) {
        return _Strings.splitThenStream(input, delimiterPattern).map(String::trim).filter(_Predicates.not(String::isEmpty));
    }

    public static String base64UrlDecode(@Nullable String str) {
        return _Strings.convert(str, _Bytes.ofUrlBase64, StandardCharsets.UTF_8);
    }

    public static String base64UrlEncode(@Nullable String str) {
        return _Strings.convert(str, _Bytes.asUrlBase64, StandardCharsets.UTF_8);
    }

    public static Stream<Character> streamCharacters(@Nullable String str) {
        return _Strings.isNotEmpty(str) ? str.codePoints().mapToObj(c -> Character.valueOf((char)c)) : Stream.empty();
    }

    public static Collector<Character, StringBuilder, String> joiningCharacters() {
        return Collector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]);
    }

    public static final class StringOperator {
        private final UnaryOperator<String> operator;

        private StringOperator(@NonNull UnaryOperator<String> operator) {
            if (operator == null) {
                throw new NullPointerException("operator is marked non-null but is null");
            }
            this.operator = operator;
        }

        public String apply(String input) {
            return (String)this.operator.apply(input);
        }

        public StringOperator andThen(UnaryOperator<String> andThen) {
            return new StringOperator(s -> (String)andThen.apply((String)this.operator.apply((String)s)));
        }
    }

    public static interface KeyValuePair
    extends Map.Entry<String, String> {
    }
}

