/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._Refs;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.springframework.lang.Nullable;

public final class _Text {
    private _Text() {
    }

    public static Stream<String> streamLines(@Nullable String text) {
        return _Strings.splitThenStream(text, "\n").map(s -> s.replace("\r", ""));
    }

    public static Can<String> getLines(@Nullable String text) {
        return Can.ofStream(_Text.streamLines(text));
    }

    public static Can<String> breakLines(Can<String> lines, int maxChars) {
        if (lines.isEmpty()) {
            return lines;
        }
        return lines.stream().flatMap(line -> _Text.breakLine(line, maxChars)).collect(Can.toCan());
    }

    public static Can<String> readLines(@Nullable InputStream input, @NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (input == null) {
            return Can.empty();
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(input, charset.name());){
            scanner.useDelimiter("\\n");
            while (scanner.hasNext()) {
                String line = scanner.next();
                lines.add(line.replace("\r", ""));
            }
        }
        return Can.ofCollection(lines);
    }

    public static Can<String> readLinesFromResource(@NonNull Class<?> resourceLocation, @NonNull String resourceName, @NonNull Charset charset) {
        Can<String> can;
        block11: {
            if (resourceLocation == null) {
                throw new NullPointerException("resourceLocation is marked non-null but is null");
            }
            if (resourceName == null) {
                throw new NullPointerException("resourceName is marked non-null but is null");
            }
            if (charset == null) {
                throw new NullPointerException("charset is marked non-null but is null");
            }
            InputStream input = resourceLocation.getResourceAsStream(resourceName);
            try {
                can = _Text.readLines(input, charset);
                if (input == null) break block11;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            input.close();
        }
        return can;
    }

    public static Can<String> readLinesFromUrl(@NonNull URL url, @NonNull Charset charset) {
        Can<String> can;
        block10: {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            if (charset == null) {
                throw new NullPointerException("charset is marked non-null but is null");
            }
            InputStream input = url.openStream();
            try {
                can = _Text.readLines(input, charset);
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            input.close();
        }
        return can;
    }

    public static Can<String> readLinesFromFile(@NonNull File file, @NonNull Charset charset) {
        Can<String> can;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        try (FileInputStream input = new FileInputStream(file);){
            can = _Text.readLines(input, charset);
        }
        return can;
    }

    public static void writeLinesToFile(@NonNull Iterable<String> lines, @NonNull File file, @NonNull Charset charset) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));){
            for (String line : lines) {
                bw.append(line).append("\n");
            }
        }
    }

    public static String normalize(@Nullable String text) {
        if (text == null) {
            return "";
        }
        return _Text.normalize(_Text.getLines(text)).stream().collect(Collectors.joining("\n"));
    }

    public static Can<String> normalize(@NonNull Can<String> lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        return _Text.removeRepeatedEmptyLines(_Text.removeTrailingEmptyLines(_Text.removeLeadingEmptyLines(lines)));
    }

    public static Can<String> removeLeadingEmptyLines(@NonNull Can<String> lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.isEmpty()) {
            return lines;
        }
        int[] nonEmptyLineCount = new int[]{0};
        return lines.stream().peek(line -> {
            if (_Text.hasNonWhiteSpaceChars(line)) {
                nonEmptyLineCount[0] = nonEmptyLineCount[0] + 1;
            }
        }).filter(line -> nonEmptyLineCount[0] > 0).collect(Can.toCan());
    }

    public static Can<String> removeTrailingEmptyLines(@NonNull Can<String> lines) {
        int lastNonEmptyLineIndex;
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.isEmpty()) {
            return lines;
        }
        int lastLineIndex = lines.size() - 1;
        if (lastLineIndex == (lastNonEmptyLineIndex = lines.stream().mapToInt(_Text.indexAndlineToIntFunction((index, line) -> _Text.hasNonWhiteSpaceChars(line) ? index : -1)).max().orElse(-1))) {
            return lines;
        }
        return lines.stream().limit(1L + (long)lastNonEmptyLineIndex).collect(Can.toCan());
    }

    public static Can<String> removeRepeatedEmptyLines(@NonNull Can<String> lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.size() < 2) {
            return lines;
        }
        int[] latestEmptyLineIndex = new int[]{-2};
        return _Text.streamLineObjects(lines).peek(line -> {
            if (!line.isEmpty()) {
                return;
            }
            if (latestEmptyLineIndex[0] == line.getIndex() - 1) {
                line.setMarkedForRemoval(true);
            }
            latestEmptyLineIndex[0] = line.getIndex();
        }).filter(line -> !line.isMarkedForRemoval()).map(Line::getString).collect(Can.toCan());
    }

    public static String abbreviate(@Nullable String input) {
        if (input == null) {
            return input;
        }
        String s = input;
        s = s.replace("org.apache.isis.", "..isis.");
        s = s.replace(".viewer.wicket.", "..wkt.");
        return s;
    }

    public static String abbreviate(@Nullable Class<?> cls) {
        if (cls == null) {
            return "[none]";
        }
        return _Text.abbreviate(cls.getCanonicalName());
    }

    public static String abbreviateClassOf(@Nullable Object obj) {
        if (obj == null) {
            return "[none]";
        }
        return _Text.abbreviate(obj.getClass());
    }

    public static void assertTextEquals(@Nullable String a, @Nullable String b) {
        _Text.assertTextEquals(_Text.getLines(a), _Text.getLines(b));
    }

    public static void assertTextEquals(@NonNull Can<String> a, @Nullable String b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        _Text.assertTextEquals(a, _Text.getLines(b));
    }

    public static void assertTextEquals(@Nullable String a, @NonNull Can<String> b) {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        _Text.assertTextEquals(_Text.getLines(a), b);
    }

    public static void assertTextEquals(@NonNull Can<String> a, @NonNull Can<String> b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        Can<String> na = _Text.normalize(a);
        Can<String> nb = _Text.normalize(b);
        _Refs.IntReference lineNrRef = _Refs.intRef(0);
        if (na.size() <= nb.size()) {
            na.zip(nb, (left, right) -> {
                int lineNr = lineNrRef.incAndGet();
                _Assert.assertEquals(left, right, () -> String.format("first non matching lineNr %d", lineNr));
            });
        } else {
            nb.zip(na, (right, left) -> {
                int lineNr = lineNrRef.incAndGet();
                _Assert.assertEquals(left, right, () -> String.format("first non matching lineNr %d", lineNr));
            });
        }
        _Assert.assertEquals((Object)na.size(), (Object)nb.size(), () -> String.format("normalized texts differ in number of lines", new Object[0]));
    }

    private static boolean hasNonWhiteSpaceChars(String s) {
        if (s == null) {
            return false;
        }
        return !s.trim().isEmpty();
    }

    private static Stream<Line> streamLineObjects(@NonNull Can<String> lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        int[] indexRef = new int[]{0};
        return lines.stream().map(line -> {
            int n = indexRef[0];
            indexRef[0] = n + 1;
            return new Line(n, (String)line);
        });
    }

    private static ToIntFunction<String> indexAndlineToIntFunction(IndexAwareLineToIntFunction mapper) {
        int[] indexRef = new int[]{0};
        return line -> {
            int n = indexRef[0];
            indexRef[0] = n + 1;
            return mapper.apply(n, (String)line);
        };
    }

    private static Stream<String> breakLine(String line, int maxChars) {
        if ((line = line.trim()).length() <= maxChars) {
            return Stream.of(line);
        }
        Can<String> tokens = Can.ofEnumeration(new StringTokenizer(line, " .-:/_", true)).map(String.class::cast);
        ArrayList constraintLines = _Lists.newArrayList();
        _Refs.IntReference partialSum = _Refs.intRef(0);
        _Refs.IntReference partialCount = _Refs.intRef(0);
        Iterator tokenIterator = tokens.iterator();
        tokens.stream().mapToInt(String::length).forEach(tokenLen -> {
            int nextLen = partialSum.getValue() + tokenLen;
            if (nextLen <= maxChars) {
                partialSum.update(x -> nextLen);
                partialCount.incAndGet();
            } else {
                constraintLines.add(IntStream.range(0, partialCount.getValue()).mapToObj(__ -> (String)tokenIterator.next()).collect(Collectors.joining()));
                partialSum.update(x -> tokenLen);
                partialCount.setValue(1);
            }
        });
        constraintLines.add(IntStream.range(0, partialCount.getValue()).mapToObj(__ -> (String)tokenIterator.next()).collect(Collectors.joining()));
        return constraintLines.stream();
    }

    private static interface IndexAwareLineToIntFunction {
        public int apply(int var1, String var2);
    }

    private static class Line {
        private final int index;
        private final String string;
        private final boolean empty;
        private boolean markedForRemoval;

        public Line(int index, String string) {
            this.index = index;
            this.string = string;
            this.empty = !_Text.hasNonWhiteSpaceChars(string);
        }

        public int getIndex() {
            return this.index;
        }

        public String getString() {
            return this.string;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public boolean isMarkedForRemoval() {
            return this.markedForRemoval;
        }

        public void setMarkedForRemoval(boolean markedForRemoval) {
            this.markedForRemoval = markedForRemoval;
        }
    }
}

