/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public final class _With<T> {
    private _With() {
    }

    public static <X> X ifPresentElse(@Nullable X obj, @Nullable X orElse) {
        return obj != null ? obj : orElse;
    }

    public static <X> X ifPresentElseGet(@Nullable X obj, Supplier<X> elseGet) {
        return obj != null ? obj : Objects.requireNonNull(elseGet, "elseGet").get();
    }

    public static <X, E extends Exception> X ifPresentElseThrow(@Nullable X obj, Supplier<E> elseThrow) throws E {
        if (obj != null) {
            return obj;
        }
        throw (Exception)Objects.requireNonNull(elseThrow, "elseThrow").get();
    }

    public static <X> X accept(@Nullable X obj, Consumer<X> consumer) {
        Objects.requireNonNull(consumer, "consumer").accept(obj);
        return obj;
    }

    public static <X> X acceptIfPresent(@Nullable X obj, Consumer<X> ifPresent) {
        if (obj != null) {
            Objects.requireNonNull(ifPresent, "ifPresent").accept(obj);
        }
        return obj;
    }

    public static <X> X acceptIfPresentElseRun(@Nullable X obj, Consumer<X> ifPresent, Runnable elseRun) {
        if (obj != null) {
            Objects.requireNonNull(ifPresent, "ifPresent").accept(obj);
        } else {
            Objects.requireNonNull(elseRun, "elseRun").run();
        }
        return obj;
    }

    public static <X, E extends Exception> X acceptIfPresentElseThrow(@Nullable X obj, Consumer<X> ifPresent, Supplier<E> elseThrow) throws E {
        if (obj == null) {
            throw (Exception)Objects.requireNonNull(elseThrow, "elseThrow").get();
        }
        Objects.requireNonNull(ifPresent, "ifPresent").accept(obj);
        return obj;
    }

    public static <X> X computeIfAbsent(@Nullable X obj, Supplier<X> supplier) {
        return obj != null ? obj : Objects.requireNonNull(supplier, "supplier").get();
    }

    public static <X, R> R mapIfPresentElse(@Nullable X obj, Function<X, R> mapper, @Nullable R orElse) {
        return obj != null ? Objects.requireNonNull(mapper, "mapper").apply(obj) : orElse;
    }

    public static <X, R> R mapIfPresentElseGet(@Nullable X obj, Function<X, R> mapper, Supplier<R> elseGet) {
        return obj != null ? Objects.requireNonNull(mapper, "mapper").apply(obj) : Objects.requireNonNull(elseGet, "elseGet").get();
    }

    public static <X, R, E extends Exception> R mapIfPresentElseThrow(@Nullable X obj, Function<X, R> mapper, Supplier<E> elseThrow) throws E {
        if (obj != null) {
            return Objects.requireNonNull(mapper, "mapper").apply(obj);
        }
        throw (Exception)Objects.requireNonNull(elseThrow, "elseThrow").get();
    }

    public static String requiresNotEmpty(@Nullable String obj, String paramName) {
        if (obj == null) {
            throw new NullPointerException(String.format("Parameter/Field '%s' is required to be present (not null).", paramName));
        }
        if (obj.length() == 0) {
            throw new IllegalArgumentException(String.format("Parameter/Field '%s' is required to be present and not empty.", paramName));
        }
        return obj;
    }

    public static <T> T create(Supplier<T> factory, Consumer<T> initializer) {
        return _With.accept(factory.get(), initializer);
    }

    public static <X> ArrayList<X> arrayList(Consumer<ArrayList<X>> initializer) {
        return _With.create(ArrayList::new, initializer);
    }

    public static <X> HashSet<X> hashSet(Consumer<HashSet<X>> initializer) {
        return _With.create(HashSet::new, initializer);
    }

    public static <X> TreeSet<X> treeSet(Consumer<TreeSet<X>> initializer) {
        return _With.create(TreeSet::new, initializer);
    }

    public static <K, V> HashMap<K, V> hashMap(Consumer<HashMap<K, V>> initializer) {
        return _With.accept(new HashMap(), initializer);
    }

    public static <K, V> TreeMap<K, V> treeMap(Consumer<TreeMap<K, V>> initializer) {
        return _With.accept(new TreeMap(), initializer);
    }

    public static StringBuilder stringBuilder(Consumer<StringBuilder> initializer) {
        return _With.create(StringBuilder::new, initializer);
    }

    public static <T> Optional<T> tryCall(Callable<T> callable) {
        try {
            T result = callable.call();
            return Optional.ofNullable(result);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> T tryOrDefault(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

