/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.collections;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.commons.internal.collections._Collections_Collector;
import org.apache.isis.commons.internal.collections._Collections_SortedSetOfList;
import org.apache.isis.commons.internal.reflection._Generics;
import org.springframework.lang.Nullable;

public final class _Collections {
    private _Collections() {
    }

    public static boolean isCollectionType(@Nullable Class<?> cls) {
        return cls != null ? Collection.class.isAssignableFrom(cls) : false;
    }

    public static boolean isCanType(@Nullable Class<?> cls) {
        return cls != null ? Can.class.isAssignableFrom(cls) : false;
    }

    public static boolean isCollectionOrArrayType(Class<?> cls) {
        return _Collections.isCollectionType(cls) || _Arrays.isArrayType(cls);
    }

    public static boolean isCollectionOrArrayOrCanType(Class<?> cls) {
        return _Collections.isCollectionType(cls) || _Arrays.isArrayType(cls) || Can.class.isAssignableFrom(cls);
    }

    public static <T> Collection<T> asUnmodifiableCollection(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        return Collections.unmodifiableCollection(list);
    }

    public static <T> List<T> asUnmodifiableList(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> Set<T> asUnmodifiableSet(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        return Collections.unmodifiableSet(list.stream().collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public static <T> SortedSet<T> asUnmodifiableSortedSet(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        return _Collections_SortedSetOfList.of(list);
    }

    public static <T> Collector<T, ?, HashSet<T>> toHashSet() {
        return Collectors.toCollection(HashSet::new);
    }

    public static <T> Collector<T, ?, ArrayList<T>> toArrayList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static <T> Collector<T, List<T>, List<T>> toUnmodifiableList() {
        return new _Collections_Collector(ArrayList::new, Collections::unmodifiableList);
    }

    public static <T> Collector<T, Set<T>, Set<T>> toUnmodifiableSet() {
        return new _Collections_Collector(HashSet::new, Collections::unmodifiableSet);
    }

    public static <T> Collector<T, SortedSet<T>, SortedSet<T>> toUnmodifiableSortedSet() {
        return new _Collections_Collector(TreeSet::new, Collections::unmodifiableSortedSet);
    }

    public static <T> Collector<T, Collection<T>, Collection<T>> toUnmodifiableCollection() {
        return new _Collections_Collector(ArrayList::new, Collections::unmodifiableCollection);
    }

    public static <T> Collector<T, SortedSet<T>, SortedSet<T>> toUnmodifiableSortedSet(@Nullable Comparator<T> comparator) {
        if (comparator == null) {
            return _Collections.toUnmodifiableSortedSet();
        }
        return new _Collections_Collector(() -> new TreeSet(comparator), Collections::unmodifiableSortedSet);
    }

    public static <T> Collector<T, ?, ? extends Collection<T>> toUnmodifiableOfType(@NonNull Class<?> typeOfCollection) {
        if (typeOfCollection == null) {
            throw new NullPointerException("typeOfCollection is marked non-null but is null");
        }
        if (SortedSet.class.equals(typeOfCollection)) {
            return _Collections.toUnmodifiableSortedSet();
        }
        if (Set.class.equals(typeOfCollection)) {
            return _Collections.toUnmodifiableSet();
        }
        if (List.class.equals(typeOfCollection)) {
            return _Collections.toUnmodifiableList();
        }
        if (Collection.class.equals(typeOfCollection)) {
            return _Collections.toUnmodifiableCollection();
        }
        throw new IllegalArgumentException(String.format("Can not collect into %s. Only List, Set, SortedSet and Collection are supported.", typeOfCollection.getClass().getName()));
    }

    static <T, R> R collectFromIterable(@Nullable Iterable<T> iterable, Function<Collection<T>, R> factory, Supplier<Collector<T, ?, R>> elementCollector) {
        if (iterable == null) {
            return factory.apply(Collections.emptyList());
        }
        if (iterable instanceof Collection) {
            return factory.apply((Collection)iterable);
        }
        return _NullSafe.stream(iterable).collect(elementCollector.get());
    }

    public static Optional<Class<?>> inferElementType(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return _Collections.isCollectionType(cls) || _Collections.isCanType(cls) ? _Generics.streamGenericTypeArgumentsOfType(cls).findFirst() : Optional.empty();
    }

    public static Optional<Class<?>> inferElementType(@NonNull Parameter param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        Class<?> parameterType = param.getType();
        return _Collections.isCollectionType(parameterType) || _Collections.isCanType(parameterType) ? _Generics.streamGenericTypeArgumentsOfParameter(param).findFirst() : Optional.empty();
    }

    public static Optional<Class<?>> inferElementType(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        Class<?> returnType = method.getReturnType();
        return _Collections.isCollectionType(returnType) || _Collections.isCanType(returnType) ? _Generics.streamGenericTypeArgumentsOfMethodReturnType(method).findFirst() : Optional.empty();
    }

    public static Optional<Class<?>> inferElementType(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Class<?> fieldType = field.getType();
        return _Collections.isCollectionType(fieldType) || _Collections.isCanType(fieldType) ? _Generics.streamGenericTypeArgumentsOfField(field).findFirst() : Optional.empty();
    }

    public static String toStringJoining(@Nullable Collection<?> collection, @NonNull String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        return _NullSafe.stream(collection).map(x -> "" + x).collect(Collectors.joining(delimiter));
    }

    public static String toStringJoiningNewLine(@Nullable Collection<?> collection) {
        return _Collections.toStringJoining(collection, "\n");
    }
}

