/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.concurrent;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import lombok.NonNull;

public abstract class _ConcurrentTask<T>
implements Runnable {
    private State status = State.NOT_STARTED;
    private long startedAtNanos;
    private long completedAtNanos;
    private long failedAtNanos;
    private T completedWith;
    private Throwable failedWith;

    public abstract String getName();

    protected synchronized void preCall() {
        if (this.startedAtNanos > 0L) {
            String msg = String.format("Cannot start task '%s' again, was already started before", this.getName());
            throw new IllegalStateException(msg);
        }
        this.startedAtNanos = System.nanoTime();
        this.status = State.STARTED;
    }

    protected void postCall(T completedWith, Throwable failedWith) {
        if (failedWith != null) {
            this.failedAtNanos = System.nanoTime();
            this.failedWith = failedWith;
            this.status = State.FAILED;
        } else {
            this.completedAtNanos = System.nanoTime();
            this.completedWith = completedWith;
            this.status = State.SUCCEEDED;
        }
    }

    abstract T innerCall() throws Exception;

    @Override
    public final void run() {
        this.preCall();
        try {
            T completedWith = this.innerCall();
            this.postCall(completedWith, null);
        }
        catch (Throwable e) {
            this.postCall(null, e);
        }
    }

    public String toString() {
        return this.getName();
    }

    public _ConcurrentTask<T> withName(final @NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        final _ConcurrentTask delegate = this;
        return new _ConcurrentTask<T>(){

            @Override
            public T innerCall() throws Exception {
                return delegate.innerCall();
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public _ConcurrentTask<T> withName(final @NonNull Supplier<String> nameSupplier) {
        if (nameSupplier == null) {
            throw new NullPointerException("nameSupplier is marked non-null but is null");
        }
        final _ConcurrentTask delegate = this;
        return new _ConcurrentTask<T>(){

            @Override
            public T innerCall() throws Exception {
                return delegate.innerCall();
            }

            @Override
            public String getName() {
                return (String)nameSupplier.get();
            }
        };
    }

    public static _ConcurrentTask<Void> of(final @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return new _ConcurrentTask<Void>(){

            @Override
            public Void innerCall() throws Exception {
                runnable.run();
                return null;
            }

            @Override
            public String getName() {
                return runnable.toString();
            }
        };
    }

    public static <X> _ConcurrentTask<X> of(final @NonNull Callable<X> callable) {
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        return new _ConcurrentTask<X>(){

            @Override
            public X innerCall() throws Exception {
                return callable.call();
            }

            @Override
            public String getName() {
                return callable.toString();
            }
        };
    }

    public State getStatus() {
        return this.status;
    }

    public long getStartedAtNanos() {
        return this.startedAtNanos;
    }

    public long getCompletedAtNanos() {
        return this.completedAtNanos;
    }

    public long getFailedAtNanos() {
        return this.failedAtNanos;
    }

    public T getCompletedWith() {
        return this.completedWith;
    }

    public Throwable getFailedWith() {
        return this.failedWith;
    }

    public static enum State {
        NOT_STARTED,
        STARTED,
        FAILED,
        SUCCEEDED;

    }
}

