/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.context;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.context._PluginResolveException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class _Plugin {
    private _Plugin() {
    }

    public static <S> Set<S> loadAll(@NonNull Class<S> service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        ServiceLoader<S> loader = ServiceLoader.load(service, _Context.getDefaultClassLoader());
        return _Sets.unmodifiable(loader);
    }

    public static <S> S getOrElse(Class<S> pluginClass, Function<Set<S>, S> onAmbiguity, Supplier<S> onNotFound) {
        return (S)_Context.computeIfAbsent(pluginClass, () -> {
            Set plugins = _Plugin.loadAll(pluginClass);
            if (plugins.isEmpty()) {
                return onNotFound.get();
            }
            if (plugins.size() > 1) {
                return onAmbiguity.apply(plugins);
            }
            return plugins.iterator().next();
        });
    }

    public static <T> T pickAnyAndWarn(Class<T> pluginInterfaceClass, Set<T> ambiguousPlugins) {
        Logger log = LogManager.getLogger(pluginInterfaceClass);
        T any = ambiguousPlugins.iterator().next();
        log.warn(String.format("You have more than one plugin implementing '%s' on your class-path [%s], just picking one: '%s'", pluginInterfaceClass.getName(), ambiguousPlugins.stream().map(p -> p.getClass().getName()).collect(Collectors.joining(", ")), any.getClass().getName()));
        return any;
    }

    public static <T> _PluginResolveException ambiguityNonRecoverable(Class<T> pluginInterfaceClass, Set<? extends T> ambiguousPlugins) {
        return new _PluginResolveException(String.format("Ambiguous plugins implementing %s found on class path.\n{%s}", pluginInterfaceClass.getName(), _NullSafe.stream(ambiguousPlugins).map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "))));
    }

    public static _PluginResolveException absenceNonRecoverable(Class<?> pluginInterfaceClass) {
        return new _PluginResolveException(String.format("No plugin implementing %s found on class path.", pluginInterfaceClass.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S> S load(Class<S> pluginInterfaceClass, File classPath, String pluginFullyQualifiedClassName) {
        try {
            ClassLoader parentCL = pluginInterfaceClass.getClassLoader();
            URL[] urls = new URL[]{classPath.toURI().toURL()};
            try (URLClassLoader cl = URLClassLoader.newInstance(urls, parentCL);){
                Class pluginClass = (Class)_Casts.uncheckedCast(cl.loadClass(pluginFullyQualifiedClassName));
                Object plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                _Context.putSingleton(pluginInterfaceClass, plugin);
                Object t = plugin;
                return (S)t;
            }
        }
        catch (Exception e) {
            throw new _PluginResolveException(String.format("Failed to load plugin '%s' implementing '%s' from path '%s'.", pluginFullyQualifiedClassName, pluginInterfaceClass.getName(), classPath.getAbsolutePath()), e);
        }
    }
}

