/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.debug;

import java.util.stream.Collectors;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.handler.ChainOfResponsibility;
import org.apache.isis.commons.internal.debug._IconResource;
import org.apache.isis.commons.internal.debug._Xray;
import org.apache.isis.commons.internal.debug.xray.XrayUi;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public final class _XrayEvent {
    public static void event(String format, Object ... args) {
        if (XrayUi.isXrayEnabled()) {
            _XrayEvent.record(1, _IconResource.EVENT, format, args);
        }
    }

    public static void interactionOpen(String format, Object ... args) {
        _XrayEvent.record(1, _IconResource.INTERACTION_OPEN, format, args);
    }

    public static void interactionClose(String format, Object ... args) {
        _XrayEvent.record(1, _IconResource.INTERACTION_CLOSE, format, args);
    }

    public static void transaction(String format, Object ... args) {
        _XrayEvent.record(1, _IconResource.TRANSACTION, format, args);
    }

    static void record(int depthLimit, _IconResource icon, String format, Object ... args) {
        Can<StackTraceElement> stackTrace = _Exceptions.streamStackTrace().skip(3L).filter(_XrayEvent::accept).collect(Can.toCan());
        String logMessage = String.format(format, args);
        _Xray.recordDebugLogEvent(icon, logMessage, stackTrace);
        String context = String.format("%s|| %s", Thread.currentThread().getName(), stackTrace.stream().limit(depthLimit).map(_XrayEvent::stringify).collect(Collectors.joining(" <- ")));
        System.err.println(context);
        System.err.println("| " + logMessage);
    }

    private static boolean accept(StackTraceElement se) {
        return se.getLineNumber() > 1 && !se.getClassName().equals(_XrayEvent.class.getName()) && !se.getClassName().contains("_Xray") && !se.getClassName().startsWith(ChainOfResponsibility.class.getName()) && !se.getClassName().startsWith("java.util.stream") && !se.getClassName().startsWith("org.junit") && !se.getClassName().startsWith("org.eclipse.jdt.internal");
    }

    private static String stringify(StackTraceElement se) {
        return _Exceptions.abbreviate(se.toString(), new String[0]);
    }

    private _XrayEvent() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

