/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.debug.xray;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.debug.xray.XrayDataModel;
import org.apache.isis.commons.internal.debug.xray.XrayModel;
import org.apache.isis.commons.internal.debug.xray.XrayModelSimple;
import org.apache.isis.commons.internal.debug.xray._CallStackMerger;
import org.apache.isis.commons.internal.debug.xray._SwingUtil;

public class XrayUi
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final JTree tree;
    private final DefaultMutableTreeNode root;
    private final XrayModel xrayModel;
    private static XrayUi INSTANCE;
    private static AtomicBoolean startRequested;
    private static CountDownLatch latch;
    private final Map<String, Optional<ImageIcon>> iconCache = _Maps.newConcurrentHashMap();

    public static void start(int defaultCloseOperation) {
        boolean alreadyRequested = startRequested.getAndSet(true);
        if (!alreadyRequested) {
            latch = new CountDownLatch(1);
            SwingUtilities.invokeLater(() -> new XrayUi(defaultCloseOperation));
        }
    }

    public static void updateModel(Consumer<XrayModel> consumer) {
        if (startRequested.get()) {
            SwingUtilities.invokeLater(() -> {
                consumer.accept(XrayUi.INSTANCE.xrayModel);
                ((DefaultTreeModel)XrayUi.INSTANCE.tree.getModel()).reload();
                _SwingUtil.setTreeExpandedState(XrayUi.INSTANCE.tree, true);
            });
        }
    }

    public static void waitForShutdown() {
        if (latch == null || INSTANCE == null) {
            return;
        }
        System.err.println("Waiting for XrayUi to shut down...");
        try {
            latch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isXrayEnabled() {
        return startRequested.get();
    }

    protected XrayUi(int defaultCloseOperation) {
        this.root = new DefaultMutableTreeNode("X-ray");
        this.xrayModel = new XrayModelSimple(this.root);
        this.tree = new JTree(this.root);
        this.tree.setShowsRootHandles(false);
        JScrollPane detailPanel = this.layoutUIAndGetDetailPanel(this.tree);
        this.tree.getSelectionModel().addTreeSelectionListener(e -> {
            TreePath selPath = e.getNewLeadSelectionPath();
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            Object userObject = selectedNode.getUserObject();
            if (userObject instanceof XrayDataModel) {
                ((XrayDataModel)userObject).render(detailPanel);
            } else {
                JPanel infoPanel = new JPanel();
                infoPanel.add(new JLabel("Details"));
                detailPanel.setViewportView(infoPanel);
            }
            detailPanel.revalidate();
            detailPanel.repaint();
        });
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem clearThreadsAction = popupMenu.add(new JMenuItem("Clear Threads"));
        clearThreadsAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XrayUi.this.doClearThreads();
            }
        });
        JMenuItem callStackMergeAction = popupMenu.add(new JMenuItem("Merge Logged Call-Stack"));
        callStackMergeAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XrayUi.this.doMergeCallStacksOnSelectedNodes();
            }
        });
        JMenuItem deleteAction = popupMenu.add(new JMenuItem("Delete"));
        deleteAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XrayUi.this.doRemoveSelectedNodes();
            }
        });
        this.tree.setCellRenderer(new XrayTreeCellRenderer((DefaultTreeCellRenderer)this.tree.getCellRenderer(), this.iconCache));
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.tree.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    XrayUi.this.doRemoveSelectedNodes();
                    return;
                }
                if (e.getKeyCode() == 116) {
                    XrayUi.this.doClearThreads();
                    return;
                }
            }
        });
        MutableTreeNode root = this.xrayModel.getRootNode();
        XrayDataModel.KeyValue env = this.xrayModel.addDataNode(root, new XrayDataModel.KeyValue("isis-xray-keys", "X-ray Keybindings", XrayModel.Stickiness.CANNOT_DELETE_NODE));
        env.getData().put("F5", "Clear Threads");
        env.getData().put("DELETE", "Delete Selected Nodes");
        this.setDefaultCloseOperation(defaultCloseOperation);
        this.setTitle("X-ray Viewer (Apache Isis\u2122)");
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        INSTANCE = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                latch.countDown();
            }
        });
    }

    private Stream<DefaultMutableTreeNode> streamSelectedNodes() {
        return Can.ofArray(this.tree.getSelectionModel().getSelectionPaths()).stream().map(path -> (DefaultMutableTreeNode)path.getLastPathComponent());
    }

    private Stream<DefaultMutableTreeNode> streamChildrenOf(DefaultMutableTreeNode node) {
        return IntStream.range(0, node.getChildCount()).mapToObj(this.root::getChildAt).map(DefaultMutableTreeNode.class::cast);
    }

    private Optional<XrayModel.HasIdAndLabel> extractUserObject(DefaultMutableTreeNode node) {
        return _Casts.castTo(XrayModel.HasIdAndLabel.class, node.getUserObject());
    }

    private boolean canRemoveNode(DefaultMutableTreeNode node) {
        if (node.getParent() == null) {
            return false;
        }
        return this.extractUserObject(node).map(XrayModel.HasIdAndLabel::getStickiness).map(stickiness -> stickiness.isCanDeleteNode()).orElse(true);
    }

    private void removeNode(DefaultMutableTreeNode nodeToBeRemoved) {
        if (this.canRemoveNode(nodeToBeRemoved)) {
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(nodeToBeRemoved);
            this.xrayModel.remove(nodeToBeRemoved);
        }
    }

    private void doClearThreads() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Can<DefaultMutableTreeNode> threadNodes = this.streamChildrenOf(root).filter(node -> this.extractUserObject((DefaultMutableTreeNode)node).map(XrayModel.HasIdAndLabel::getId).map(id -> id.startsWith("thread-")).orElse(false)).collect(Can.toCan());
        threadNodes.forEach(this::removeNode);
    }

    private void doRemoveSelectedNodes() {
        this.streamSelectedNodes().forEach(this::removeNode);
    }

    private void doMergeCallStacksOnSelectedNodes() {
        Can<XrayDataModel.LogEntry> logEntries = this.streamSelectedNodes().filter(node -> node.getUserObject() instanceof XrayDataModel.LogEntry).map(node -> (XrayDataModel.LogEntry)node.getUserObject()).collect(Can.toCan());
        if (!logEntries.getCardinality().isMultiple()) {
            System.err.println("must select at least 2 logs for merging");
            return;
        }
        _CallStackMerger callStackMerger = new _CallStackMerger(logEntries);
        JFrame frame = new JFrame("Merged Log View");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(true);
        JTextArea textArea = new JTextArea("no content");
        textArea.setFont(new Font("Serif", 0, 16));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scroller = new JScrollPane(textArea);
        callStackMerger.render(textArea);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setHorizontalScrollBarPolicy(31);
        panel.add(scroller);
        frame.getContentPane().add("Center", panel);
        frame.setPreferredSize(new Dimension(800, 600));
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
        frame.setResizable(true);
        frame.setVisible(true);
    }

    private JScrollPane layoutUIAndGetDetailPanel(JTree masterTree) {
        JScrollPane masterScrollPane = new JScrollPane(masterTree);
        JScrollPane detailScrollPane = new JScrollPane();
        JSplitPane splitPane = new JSplitPane(1, masterScrollPane, detailScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(260);
        Dimension minimumSize = new Dimension(100, 50);
        masterScrollPane.setMinimumSize(minimumSize);
        detailScrollPane.setMinimumSize(minimumSize);
        detailScrollPane.setVerticalScrollBarPolicy(20);
        detailScrollPane.setHorizontalScrollBarPolicy(30);
        detailScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        splitPane.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().add(splitPane);
        return detailScrollPane;
    }

    static {
        startRequested = new AtomicBoolean();
        latch = null;
    }

    class XrayTreeCellRenderer
    implements TreeCellRenderer {
        final DefaultTreeCellRenderer delegate;
        final Map<String, Optional<ImageIcon>> iconCache;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultTreeCellRenderer label = (DefaultTreeCellRenderer)this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Object o = ((DefaultMutableTreeNode)value).getUserObject();
            if (o instanceof XrayDataModel) {
                XrayDataModel dataModel = (XrayDataModel)o;
                Optional imageIcon = this.iconCache.computeIfAbsent(dataModel.getIconResource(), iconResource -> {
                    URL imageUrl = this.getClass().getResource(dataModel.getIconResource());
                    return Optional.ofNullable(imageUrl).map(ImageIcon::new);
                });
                imageIcon.ifPresent(label::setIcon);
                label.setText(dataModel.getLabel());
            }
            return label;
        }

        public XrayTreeCellRenderer(DefaultTreeCellRenderer delegate, Map<String, Optional<ImageIcon>> iconCache) {
            this.delegate = delegate;
            this.iconCache = iconCache;
        }
    }
}

