/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.exceptions;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Refs;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.springframework.lang.Nullable;

public final class _Exceptions {
    private static final Map<String, String> packageReplacements = Map.of("org.apache.wicket", "{wkt}", "org.springframework", "{spring}", "org.apache.tomcat", "{tomcat}", "org.apache.catalina", "{catalina}", "org.apache.coyote", "{coyote}");

    private _Exceptions() {
    }

    public static final IllegalArgumentException unmatchedCase(@Nullable Object _case) {
        return new IllegalArgumentException("internal error: unmatched case in switch statement: " + _case);
    }

    public static final IllegalArgumentException illegalArgument(@NonNull String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        return new IllegalArgumentException(String.format(format, args));
    }

    public static IllegalStateException illegalState(@NonNull String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        return new IllegalStateException(String.format(format, args));
    }

    public static IllegalStateException illegalState(@NonNull Throwable cause, @NonNull String format, Object ... args) {
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        return new IllegalStateException(String.format(format, args), cause);
    }

    public static IllegalAccessException illegalAccess(@NonNull String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        return new IllegalAccessException(String.format(format, args));
    }

    public static final NoSuchElementException noSuchElement() {
        return new NoSuchElementException();
    }

    public static final NoSuchElementException noSuchElement(String msg) {
        return new NoSuchElementException(msg);
    }

    public static final NoSuchElementException noSuchElement(@NonNull String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        return _Exceptions.noSuchElement(String.format(format, args));
    }

    public static final IllegalStateException unexpectedCodeReach() {
        return new IllegalStateException("internal error: code was reached, that is expected unreachable");
    }

    public static IllegalStateException notImplemented() {
        return new IllegalStateException("internal error: code was reached, that is not implemented yet");
    }

    public static RuntimeException unrecoverable(Throwable cause) {
        return new RuntimeException("unrecoverable error: with cause ...", cause);
    }

    public static RuntimeException unrecoverable(String msg) {
        return new RuntimeException(String.format("unrecoverable error: '%s'", msg));
    }

    public static RuntimeException unrecoverable(String msg, Throwable cause) {
        return new RuntimeException(String.format("unrecoverable error: '%s' with cause ...", msg), cause);
    }

    public static RuntimeException unrecoverableFormatted(String format, Object ... args) {
        return new RuntimeException(String.format("unrecoverable error: '%s'", String.format(format, args)));
    }

    public static UnsupportedOperationException unsupportedOperation() {
        return new UnsupportedOperationException("unrecoverable error: method call not allowed/supported");
    }

    public static UnsupportedOperationException unsupportedOperation(String msg) {
        return new UnsupportedOperationException(msg);
    }

    public static UnsupportedOperationException unsupportedOperation(String format, Object ... args) {
        return new UnsupportedOperationException(String.format(format, args));
    }

    public static AssertionError assertionError(String msg) {
        return new AssertionError((Object)msg);
    }

    public static String getMessage(Throwable ex) {
        if (ex == null) {
            return "no exception present";
        }
        if (_Strings.isNotEmpty(ex.getMessage())) {
            return ex.getMessage();
        }
        StringBuilder sb = new StringBuilder();
        Optional<String> nestedMsg = _Exceptions.streamCausalChain(ex).peek(throwable -> sb.append(throwable.getClass().getSimpleName()).append("/")).map(Throwable::getMessage).filter(_NullSafe::isPresent).findFirst();
        if (nestedMsg.isPresent()) {
            sb.append(nestedMsg.get());
        } else {
            Can.ofArray(ex.getStackTrace()).stream().limit(20L).forEach(trace -> sb.append("\n").append(trace));
        }
        return sb.toString();
    }

    public static void throwUnexpectedCodeReach() {
        throw _Exceptions.unexpectedCodeReach();
    }

    public static void throwNotImplemented() {
        _Exceptions.dumpStackTrace();
        throw _Exceptions.notImplemented();
    }

    public static <E extends Exception> void throwWhenTrue(E cause, Predicate<E> test) throws E {
        if (test.test(cause)) {
            throw cause;
        }
    }

    public static final Stream<String> streamStacktraceLines(@Nullable Throwable ex, int maxLines) {
        if (ex == null) {
            return Stream.empty();
        }
        return _NullSafe.stream(ex.getStackTrace()).map(StackTraceElement::toString).limit(maxLines);
    }

    public static final String asStacktrace(@Nullable Throwable ex, int maxLines, String delimiter) {
        return _Exceptions.streamStacktraceLines(ex, maxLines).collect(Collectors.joining(delimiter));
    }

    public static final String asStacktrace(@Nullable Throwable ex, int maxLines) {
        return _Exceptions.asStacktrace(ex, maxLines, "\n");
    }

    public static final String asStacktrace(@Nullable Throwable ex) {
        return _Exceptions.asStacktrace(ex, 1000);
    }

    public static void dumpStackTrace(PrintStream writer, int skipLines, int maxLines) {
        _Exceptions.streamStackTrace().map(StackTraceElement::toString).skip(skipLines).limit(maxLines).forEach(writer::println);
    }

    public static void dumpStackTrace() {
        _Exceptions.dumpStackTrace(System.err, 0, 1000);
    }

    public static List<Throwable> getCausalChain(@Nullable Throwable ex) {
        if (ex == null) {
            return Collections.emptyList();
        }
        ArrayList<Throwable> chain = _Lists.newArrayList();
        for (Throwable t = ex; t != null; t = t.getCause()) {
            chain.add(t);
        }
        return chain;
    }

    public static Stream<StackTraceElement> streamStackTrace() {
        return _NullSafe.stream(Thread.currentThread().getStackTrace());
    }

    public static Stream<Throwable> streamCausalChain(@Nullable Throwable ex) {
        if (ex == null) {
            return Stream.empty();
        }
        List<Throwable> chain = _Exceptions.getCausalChain(ex);
        return chain.stream();
    }

    public static Throwable getRootCause(@Nullable Throwable ex) {
        return _Lists.lastElementIfAny(_Exceptions.getCausalChain(ex));
    }

    public static void silence(Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        Thread.UncaughtExceptionHandler silencedHandler = currentThread.getUncaughtExceptionHandler();
        currentThread.setUncaughtExceptionHandler((t, e) -> {});
        try {
            runnable.run();
        }
        finally {
            currentThread.setUncaughtExceptionHandler(silencedHandler);
        }
    }

    public static boolean containsAnyOfTheseMessages(@Nullable Throwable throwable, String ... messages) {
        if (throwable == null) {
            return false;
        }
        String throwableMessage = throwable.getMessage();
        if (throwableMessage == null || _NullSafe.isEmpty(messages)) {
            return false;
        }
        for (String message : messages) {
            if (!_Strings.isNotEmpty(message) || !throwableMessage.contains(message)) continue;
            return true;
        }
        return false;
    }

    public static String abbreviate(String className, String ... compress) {
        String str = className;
        return Stream.concat(_NullSafe.stream(compress).map(prefix -> Map.entry(prefix, "")), packageReplacements.entrySet().stream()).filter(entry -> str.startsWith((String)entry.getKey())).map(entry -> {
            String replacement = (String)entry.getValue();
            Object s = str;
            s = ((String)s).replace((String)entry.getKey() + ".", (CharSequence)(replacement.isEmpty() ? "{" : replacement + "."));
            _Refs.StringReference ref = _Refs.stringRef((String)s);
            String left = ref.cutAtIndexOfAndDrop(".");
            String right = ref.getValue();
            s = replacement.isEmpty() ? left + "}." + right : left + "." + right;
            return s;
        }).findFirst().orElse(str);
    }

    public static class FluentException<E extends Exception> {
        private final E cause;

        public static <E extends Exception> FluentException<E> of(E cause) {
            return new FluentException<E>(cause);
        }

        private FluentException(@NonNull E cause) {
            if (cause == null) {
                throw new NullPointerException("cause is marked non-null but is null");
            }
            this.cause = cause;
        }

        public E getCause() {
            return this.cause;
        }

        public Optional<String> getMessage() {
            return Optional.ofNullable(((Throwable)this.cause).getMessage());
        }

        public void rethrow() throws E {
            throw this.cause;
        }

        public void rethrowIf(@NonNull Predicate<E> condition) throws E {
            if (condition == null) {
                throw new NullPointerException("condition is marked non-null but is null");
            }
            if (condition.test(this.cause)) {
                throw this.cause;
            }
        }

        public void suppressIf(@NonNull Predicate<E> condition) throws E {
            if (condition == null) {
                throw new NullPointerException("condition is marked non-null but is null");
            }
            if (!condition.test(this.cause)) {
                throw this.cause;
            }
        }

        public void rethrowIfMessageContains(@NonNull String string) throws E {
            if (string == null) {
                throw new NullPointerException("string is marked non-null but is null");
            }
            boolean containsMessage = this.getMessage().map(msg -> msg.contains(string)).orElse(false);
            if (containsMessage) {
                throw this.cause;
            }
        }

        public void suppressIfMessageContains(@NonNull String string) throws E {
            if (string == null) {
                throw new NullPointerException("string is marked non-null but is null");
            }
            boolean containsMessage = this.getMessage().map(msg -> msg.contains(string)).orElse(false);
            if (!containsMessage) {
                throw this.cause;
            }
        }
    }
}

