/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.graph;

import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.isis.commons.collections.Can;

public class _Graph<T> {
    private final Can<T> nodes;
    private final BiPredicate<T, T> relationPredicate;

    public Stream<T> streamNeighbors(T a) {
        return this.nodes.stream().filter(b -> !a.equals(b)).filter(b -> this.relationPredicate.test(a, b));
    }

    private _Graph(Can<T> nodes, BiPredicate<T, T> relationPredicate) {
        this.nodes = nodes;
        this.relationPredicate = relationPredicate;
    }

    public static <T> _Graph<T> of(Can<T> nodes, BiPredicate<T, T> relationPredicate) {
        return new _Graph<T>(nodes, relationPredicate);
    }
}

