/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.ioc;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Qualifier;
import lombok.NonNull;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.ioc._IocContainer;
import org.apache.isis.commons.internal.ioc._ManagedBeanAdapter;
import org.apache.isis.commons.internal.ioc._ManagedBeanAdapter_Spring;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;

final class _IocContainer_Spring
implements _IocContainer {
    @NonNull
    private final ApplicationContext springContext;

    @Override
    public <T> Optional<T> get(@NonNull Class<T> requiredType) {
        if (requiredType == null) {
            throw new NullPointerException("requiredType is marked non-null but is null");
        }
        ObjectProvider provider = this.springContext.getBeanProvider(requiredType);
        try {
            return Optional.ofNullable(provider.getIfUnique());
        }
        catch (Exception cause) {
            throw _Exceptions.unrecoverable("Failed to create an instance of type " + requiredType, cause);
        }
    }

    @Override
    public Stream<_ManagedBeanAdapter> streamAllBeans() {
        ApplicationContext context = this.springContext;
        return Stream.of(context.getBeanDefinitionNames()).map(name -> {
            Class type = context.getType(name);
            String id = name;
            ResolvableType resolvableType = ResolvableType.forClass((Class)type);
            ObjectProvider bean = context.getBeanProvider(resolvableType);
            _ManagedBeanAdapter_Spring beanAdapter = _ManagedBeanAdapter_Spring.of(id, type, bean);
            return beanAdapter;
        });
    }

    @Override
    public Optional<?> lookupById(String id) {
        return this.springContext.containsBean(id) ? Optional.of(this.springContext.getBean(id)) : Optional.empty();
    }

    @Override
    public <T> Can<T> select(@NonNull Class<T> requiredType) {
        if (requiredType == null) {
            throw new NullPointerException("requiredType is marked non-null but is null");
        }
        Can allMatchingBeans = this.springContext.getBeanProvider(requiredType).orderedStream().collect(Can.toCan());
        return allMatchingBeans;
    }

    @Override
    public <T> Can<T> select(@NonNull Class<T> requiredType, @Nullable Annotation[] qualifiers) {
        if (requiredType == null) {
            throw new NullPointerException("requiredType is marked non-null but is null");
        }
        Set<Annotation> qualifiersRequired = _IocContainer_Spring.filterQualifiers(qualifiers);
        if (_NullSafe.isEmpty(qualifiersRequired)) {
            Can allMatchingBeans = this.springContext.getBeanProvider(requiredType).orderedStream().collect(Can.toCan());
            return allMatchingBeans;
        }
        Can allMatchingBeans = this.springContext.getBeanProvider(requiredType).orderedStream().filter(t -> {
            Set<Annotation> qualifiersPresent = _Sets.of(t.getClass().getAnnotations());
            return qualifiersPresent.containsAll(qualifiersRequired);
        }).collect(Can.toCan());
        return allMatchingBeans;
    }

    private static Set<Annotation> filterQualifiers(@Nullable Annotation[] annotations) {
        if (_NullSafe.isEmpty(annotations)) {
            return Collections.emptySet();
        }
        return _NullSafe.stream(annotations).filter(_IocContainer_Spring::isGenericQualifier).collect(Collectors.toSet());
    }

    private static boolean isGenericQualifier(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        if (((Qualifier[])annotation.annotationType().getAnnotationsByType(Qualifier.class)).length > 0) {
            return true;
        }
        return annotation.annotationType().equals(Primary.class);
    }

    private _IocContainer_Spring(@NonNull ApplicationContext springContext) {
        if (springContext == null) {
            throw new NullPointerException("springContext is marked non-null but is null");
        }
        this.springContext = springContext;
    }

    public static _IocContainer_Spring of(@NonNull ApplicationContext springContext) {
        return new _IocContainer_Spring(springContext);
    }
}

