/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.primitives;

import java.util.OptionalLong;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public final class _Longs {
    private static final Consumer<String> IGNORE_ERRORS = t -> {};

    public static Range rangeClosed(long a, long b) {
        if (a > b) {
            throw _Exceptions.illegalArgument("bounds must be ordered in [%d, %d]", a, b);
        }
        return Range.of(Bound.inclusive(a), Bound.inclusive(b));
    }

    public static Range rangeOpenEnded(long a, long b) {
        if (a == b) {
            throw _Exceptions.unsupportedOperation("empty range not implemented");
        }
        if (a >= b) {
            throw _Exceptions.illegalArgument("bounds must be ordered in [%d, %d]", a, b);
        }
        return Range.of(Bound.inclusive(a), Bound.exclusive(b));
    }

    public static OptionalLong parseLong(@Nullable String s, int radix, @NonNull Consumer<String> onFailure) {
        if (onFailure == null) {
            throw new NullPointerException("onFailure is marked non-null but is null");
        }
        if (s == null) {
            onFailure.accept("null");
            OptionalLong.empty();
        }
        if (radix < 2) {
            onFailure.accept("radix " + radix + " less than Character.MIN_RADIX");
            OptionalLong.empty();
        }
        if (radix > 36) {
            onFailure.accept("radix " + radix + " greater than Character.MAX_RADIX");
            OptionalLong.empty();
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    onFailure.accept(s);
                    OptionalLong.empty();
                }
                if (len == 1) {
                    onFailure.accept(s);
                    OptionalLong.empty();
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    onFailure.accept(s);
                    OptionalLong.empty();
                }
                if (result < multmin) {
                    onFailure.accept(s);
                    OptionalLong.empty();
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    onFailure.accept(s);
                    OptionalLong.empty();
                }
                result -= (long)digit;
            }
        } else {
            onFailure.accept(s);
            OptionalLong.empty();
        }
        return OptionalLong.of(negative ? result : -result);
    }

    public static OptionalLong parseLong(String s, int radix) {
        return _Longs.parseLong(s, radix, IGNORE_ERRORS);
    }

    private _Longs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Range {
        @NonNull
        private final Bound lowerBound;
        @NonNull
        private final Bound upperBound;

        public boolean contains(long value) {
            boolean isAboveUpper;
            boolean isBelowLower;
            boolean bl = this.lowerBound.isInclusive() ? value < this.lowerBound.getValue() : (isBelowLower = value <= this.lowerBound.getValue());
            if (isBelowLower) {
                return false;
            }
            boolean bl2 = this.upperBound.isInclusive() ? value > this.upperBound.getValue() : (isAboveUpper = value >= this.upperBound.getValue());
            return !isAboveUpper;
        }

        public long bounded(long value) {
            long nearestToUpper;
            long distanceToUpper;
            if (this.contains(value)) {
                return value;
            }
            long nearestToLower = this.nearestToLower();
            long distanceToLower = value - nearestToLower;
            return distanceToLower <= (distanceToUpper = value - (nearestToUpper = this.nearestToUpper())) ? nearestToLower : nearestToUpper;
        }

        private long nearestToLower() {
            return this.lowerBound.isInclusive() ? this.lowerBound.getValue() : this.lowerBound.getValue() + 1L;
        }

        private long nearestToUpper() {
            return this.upperBound.isInclusive() ? this.upperBound.getValue() : this.upperBound.getValue() - 1L;
        }

        public String toString() {
            return String.format("%s%d,%d%S", Character.valueOf(this.lowerBound.isInclusive() ? (char)'[' : '('), this.lowerBound.getValue(), this.upperBound.getValue(), Character.valueOf(this.upperBound.isInclusive() ? (char)']' : ')'));
        }

        private Range(@NonNull Bound lowerBound, @NonNull Bound upperBound) {
            if (lowerBound == null) {
                throw new NullPointerException("lowerBound is marked non-null but is null");
            }
            if (upperBound == null) {
                throw new NullPointerException("upperBound is marked non-null but is null");
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public static Range of(@NonNull Bound lowerBound, @NonNull Bound upperBound) {
            return new Range(lowerBound, upperBound);
        }

        @NonNull
        public Bound getLowerBound() {
            return this.lowerBound;
        }

        @NonNull
        public Bound getUpperBound() {
            return this.upperBound;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            Bound this$lowerBound = this.getLowerBound();
            Bound other$lowerBound = other.getLowerBound();
            if (this$lowerBound == null ? other$lowerBound != null : !((Object)this$lowerBound).equals(other$lowerBound)) {
                return false;
            }
            Bound this$upperBound = this.getUpperBound();
            Bound other$upperBound = other.getUpperBound();
            return !(this$upperBound == null ? other$upperBound != null : !((Object)this$upperBound).equals(other$upperBound));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Bound $lowerBound = this.getLowerBound();
            result = result * 59 + ($lowerBound == null ? 43 : ((Object)$lowerBound).hashCode());
            Bound $upperBound = this.getUpperBound();
            result = result * 59 + ($upperBound == null ? 43 : ((Object)$upperBound).hashCode());
            return result;
        }
    }

    public static final class Bound {
        private final long value;
        private final boolean inclusive;

        @NonNull
        public static Bound inclusive(long value) {
            return Bound.of(value, true);
        }

        @NonNull
        public static Bound exclusive(long value) {
            return Bound.of(value, true);
        }

        private Bound(long value, boolean inclusive) {
            this.value = value;
            this.inclusive = inclusive;
        }

        public static Bound of(long value, boolean inclusive) {
            return new Bound(value, inclusive);
        }

        public long getValue() {
            return this.value;
        }

        public boolean isInclusive() {
            return this.inclusive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bound)) {
                return false;
            }
            Bound other = (Bound)o;
            if (this.getValue() != other.getValue()) {
                return false;
            }
            return this.isInclusive() == other.isInclusive();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $value = this.getValue();
            result = result * 59 + (int)($value >>> 32 ^ $value);
            result = result * 59 + (this.isInclusive() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "_Longs.Bound(value=" + this.getValue() + ", inclusive=" + this.isInclusive() + ")";
        }
    }
}

