/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.proxy;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.commons.internal.proxy._ProxyFactory;
import org.apache.isis.commons.internal.proxy._ProxyFactoryService;

public abstract class _ProxyFactoryServiceAbstract
implements _ProxyFactoryService {
    @NonNull
    private final Map<Class<?>, _ProxyFactory<?>> proxyFactoryByClass = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public <T> _ProxyFactory<T> factory(Class<T> toProxyClass, Class<?> additionalClass) {
        _ProxyFactory<T> proxyFactory = (_ProxyFactory<T>)_Casts.uncheckedCast(this.proxyFactoryByClass.get(toProxyClass));
        if (proxyFactory == null) {
            proxyFactory = this.createFactory(toProxyClass, additionalClass);
            this.proxyFactoryByClass.put(toProxyClass, proxyFactory);
        }
        return proxyFactory;
    }

    private <T> _ProxyFactory<T> createFactory(Class<T> toProxyClass, Class<?> additionalClass) {
        Class[] interfaces = _Arrays.combine(toProxyClass.getInterfaces(), new Class[]{_ProxyFactoryService.ProxyEnhanced.class, additionalClass});
        _ProxyFactory<T> proxyFactory = _ProxyFactory.builder(toProxyClass).interfaces(interfaces).build(this);
        return proxyFactory;
    }
}

