/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.reflection._Annotations_AttributeMethods;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.SynthesizedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

final class _Annotations_SynthesizedMergedAnnotationInvocationHandler<A extends Annotation>
implements InvocationHandler {
    @NonNull
    private final MergedAnnotations mergedAnnotations;
    @Nullable
    private final MergedAnnotations additionalAnnotations;
    private final Class<A> type;
    private final _Annotations_AttributeMethods attributes;
    @Nullable
    private volatile Integer hashCode;

    private _Annotations_SynthesizedMergedAnnotationInvocationHandler(MergedAnnotations mergedAnnotations, MergedAnnotations additionalAnnotations, Class<A> type) {
        Assert.notNull((Object)mergedAnnotations, (String)"MergedAnnotations must not be null");
        Assert.notNull(type, (String)"Type must not be null");
        Assert.isTrue((boolean)type.isAnnotation(), (String)"Type must be an annotation");
        this.mergedAnnotations = mergedAnnotations;
        this.additionalAnnotations = additionalAnnotations;
        this.type = type;
        this.attributes = _Annotations_AttributeMethods.forAnnotationType(type);
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.getAttributeValue(this.attributes.get(i));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (ReflectionUtils.isEqualsMethod((Method)method)) {
            return this.annotationEquals(args[0]);
        }
        if (ReflectionUtils.isHashCodeMethod((Method)method)) {
            return this.annotationHashCode();
        }
        if (ReflectionUtils.isToStringMethod((Method)method)) {
            return this.mergedAnnotations.toString();
        }
        if (this.isAnnotationTypeMethod(method)) {
            return this.type;
        }
        if (this.attributes.indexOf(method.getName()) != -1) {
            return this.getAttributeValue(method);
        }
        throw new AnnotationConfigurationException(String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method, this.type));
    }

    private boolean isAnnotationTypeMethod(Method method) {
        return Objects.equals(method.getName(), "annotationType") && method.getParameterCount() == 0;
    }

    private boolean annotationEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.type.isInstance(other)) {
            return false;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Object otherValue;
            Method attribute = this.attributes.get(i);
            Object thisValue = this.getAttributeValue(attribute);
            if (ObjectUtils.nullSafeEquals((Object)thisValue, (Object)(otherValue = ReflectionUtils.invokeMethod((Method)attribute, (Object)other)))) continue;
            return false;
        }
        return true;
    }

    private int annotationHashCode() {
        Integer hashCode = this.hashCode;
        if (hashCode == null) {
            this.hashCode = hashCode = this.computeHashCode();
        }
        return hashCode;
    }

    private Integer computeHashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Method attribute = this.attributes.get(i);
            Object value = this.getAttributeValue(attribute);
            hashCode += 127 * attribute.getName().hashCode() ^ this.getValueHashCode(value);
        }
        return hashCode;
    }

    private int getValueHashCode(Object value) {
        if (value instanceof boolean[]) {
            return Arrays.hashCode((boolean[])value);
        }
        if (value instanceof byte[]) {
            return Arrays.hashCode((byte[])value);
        }
        if (value instanceof char[]) {
            return Arrays.hashCode((char[])value);
        }
        if (value instanceof double[]) {
            return Arrays.hashCode((double[])value);
        }
        if (value instanceof float[]) {
            return Arrays.hashCode((float[])value);
        }
        if (value instanceof int[]) {
            return Arrays.hashCode((int[])value);
        }
        if (value instanceof long[]) {
            return Arrays.hashCode((long[])value);
        }
        if (value instanceof short[]) {
            return Arrays.hashCode((short[])value);
        }
        if (value instanceof Object[]) {
            return Arrays.hashCode((Object[])value);
        }
        return value.hashCode();
    }

    @Nullable
    private Object getAttributeValue(Method method) {
        String name = method.getName();
        Class type = ClassUtils.resolvePrimitiveIfNecessary(method.getReturnType());
        Object defaultValue = method.getDefaultValue();
        Object attributeValue = this.streamAnnotations().map(mergedAnnotation -> mergedAnnotation.getValue(name, type).orElse(null)).filter(_NullSafe::isPresent).filter(value -> !value.equals(defaultValue)).findFirst().orElse(defaultValue);
        return attributeValue;
    }

    static <A extends Annotation> Optional<A> createProxy(@NonNull MergedAnnotations collected, @NonNull Optional<MergedAnnotations> additional, @NonNull Class<A> annotationType) {
        Class[] classArray;
        if (collected == null) {
            throw new NullPointerException("collected is marked non-null but is null");
        }
        if (additional == null) {
            throw new NullPointerException("additional is marked non-null but is null");
        }
        if (annotationType == null) {
            throw new NullPointerException("annotationType is marked non-null but is null");
        }
        boolean hasCollected = collected.isPresent(annotationType);
        Boolean hasAdditional = additional.map(mergedAnnotations -> mergedAnnotations.isPresent(annotationType)).orElse(false);
        if (!hasCollected && !hasAdditional.booleanValue()) {
            return Optional.empty();
        }
        _Annotations_SynthesizedMergedAnnotationInvocationHandler<A> invocationHandler = hasCollected ? new _Annotations_SynthesizedMergedAnnotationInvocationHandler<A>(collected, additional.orElse(null), annotationType) : new _Annotations_SynthesizedMergedAnnotationInvocationHandler<A>(additional.get(), null, annotationType);
        ClassLoader classLoader = annotationType.getClassLoader();
        if (_Annotations_SynthesizedMergedAnnotationInvocationHandler.isVisible(classLoader, SynthesizedAnnotation.class)) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = annotationType;
            classArray = classArray2;
            classArray2[1] = SynthesizedAnnotation.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = annotationType;
        }
        Class[] interfaces = classArray;
        Annotation proxy = (Annotation)Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        return Optional.of(proxy);
    }

    private static boolean isVisible(ClassLoader classLoader, Class<?> interfaceClass) {
        try {
            return Class.forName(interfaceClass.getName(), false, classLoader) == interfaceClass;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private Stream<MergedAnnotation<A>> streamAnnotations() {
        return this.additionalAnnotations != null ? Stream.concat(this.mergedAnnotations.stream(this.type), this.additionalAnnotations.stream(this.type)).sorted((a, b) -> Integer.compare(a.getAggregateIndex(), b.getAggregateIndex())) : this.mergedAnnotations.stream(this.type);
    }
}

