/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.resources;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.resources._Resources;

public interface _DataSource
extends Supplier<InputStream> {
    public Serializable identifier();

    default public byte[] asBytes() {
        byte[] byArray;
        block8: {
            InputStream is = (InputStream)this.get();
            try {
                byArray = _Bytes.of(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return _Constants.emptyBytes;
                }
            }
            is.close();
        }
        return byArray;
    }

    default public boolean isPresent() {
        boolean bl;
        block8: {
            InputStream is = (InputStream)this.get();
            try {
                boolean bl2 = bl = is != null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static _DataSource classPathResource(final @NonNull Class<?> contextClass, final @NonNull String resourceName) {
        if (contextClass == null) {
            throw new NullPointerException("contextClass is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        final class Key
        implements Serializable {
            private static final long serialVersionUID = 1L;
            @NonNull
            private final Class<?> contextClass;
            @NonNull
            private final String resourceName;

            public Key(@NonNull Class<?> contextClass, @NonNull String resourceName) {
                if (contextClass == null) {
                    throw new NullPointerException("contextClass is marked non-null but is null");
                }
                if (resourceName == null) {
                    throw new NullPointerException("resourceName is marked non-null but is null");
                }
                this.contextClass = contextClass;
                this.resourceName = resourceName;
            }

            @NonNull
            public Class<?> getContextClass() {
                return this.contextClass;
            }

            @NonNull
            public String getResourceName() {
                return this.resourceName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Key)) {
                    return false;
                }
                Key other = (Key)o;
                Class<?> this$contextClass = this.getContextClass();
                Class<?> other$contextClass = other.getContextClass();
                if (this$contextClass == null ? other$contextClass != null : !this$contextClass.equals(other$contextClass)) {
                    return false;
                }
                String this$resourceName = this.getResourceName();
                String other$resourceName = other.getResourceName();
                return !(this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Class<?> $contextClass = this.getContextClass();
                result = result * 59 + ($contextClass == null ? 43 : $contextClass.hashCode());
                String $resourceName = this.getResourceName();
                result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
                return result;
            }

            public String toString() {
                return "Key(contextClass=" + this.getContextClass() + ", resourceName=" + this.getResourceName() + ")";
            }
        }
        final Key key = new Key(contextClass, resourceName);
        return new _DataSource(){
            {
            }

            @Override
            public Serializable identifier() {
                return key;
            }

            @Override
            public InputStream get() {
                return _Resources.load(contextClass, resourceName);
            }
        };
    }

    public static _DataSource classPathResource(final @NonNull URL resourceUrl) {
        if (resourceUrl == null) {
            throw new NullPointerException("resourceUrl is marked non-null but is null");
        }
        return new _DataSource(){

            @Override
            public Serializable identifier() {
                return resourceUrl;
            }

            @Override
            public InputStream get() {
                return resourceUrl.openStream();
            }
        };
    }

    public static _DataSource classPathResource(@NonNull String absoluteResourceName) {
        if (absoluteResourceName == null) {
            throw new NullPointerException("absoluteResourceName is marked non-null but is null");
        }
        if (!absoluteResourceName.startsWith("/")) {
            throw _Exceptions.illegalArgument("invalid absoluteResourceName %s", absoluteResourceName);
        }
        URL resourceUrl = _Context.getDefaultClassLoader().getResource(absoluteResourceName);
        if (resourceUrl == null) {
            throw _Exceptions.noSuchElement("resource not found %s", absoluteResourceName);
        }
        return _DataSource.classPathResource(resourceUrl);
    }
}

