/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.resources;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;
import org.apache.isis.commons.functional.Result;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.codec._DocumentFactories;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.reflection._Annotations;
import org.springframework.lang.Nullable;

public final class _Xml {
    private static Map<Class<?>, JAXBContext> jaxbContextByClass = _Maps.newConcurrentHashMap();

    public static <T> T _readXml(@NonNull Class<T> dtoClass, @NonNull Reader reader, @NonNull ReadOptions readOptions) {
        if (dtoClass == null) {
            throw new NullPointerException("dtoClass is marked non-null but is null");
        }
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (readOptions == null) {
            throw new NullPointerException("readOptions is marked non-null but is null");
        }
        Unmarshaller unmarshaller = _Xml.jaxbContextFor(dtoClass, readOptions.isUseContextCache()).createUnmarshaller();
        if (readOptions.isAllowMissingRootElement() && !_Annotations.isPresent(dtoClass, XmlRootElement.class)) {
            XMLStreamReader xsr = _DocumentFactories.xmlInputFactory().createXMLStreamReader(reader);
            JAXBElement userElement = unmarshaller.unmarshal(xsr, dtoClass);
            return (T)userElement.getValue();
        }
        return _Casts.uncheckedCast(unmarshaller.unmarshal(reader));
    }

    private static <T> String _writeXml(@NonNull T dto, @NonNull WriteOptions writeOptions) throws JAXBException {
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        if (writeOptions == null) {
            throw new NullPointerException("writeOptions is marked non-null but is null");
        }
        StringWriter writer = new StringWriter();
        _Xml.writeXml(dto, writer, writeOptions);
        return writer.toString();
    }

    public static <T> Result<String> writeXml(@NonNull T dto, @NonNull WriteOptions writeOptions) {
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        if (writeOptions == null) {
            throw new NullPointerException("writeOptions is marked non-null but is null");
        }
        return Result.of(() -> _Xml._writeXml(dto, writeOptions));
    }

    public static <T> void writeXml(@NonNull T dto, @NonNull Writer writer, @NonNull WriteOptions writeOptions) throws JAXBException {
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        if (writeOptions == null) {
            throw new NullPointerException("writeOptions is marked non-null but is null");
        }
        Class dtoClass = (Class)_Casts.uncheckedCast(dto.getClass());
        Marshaller marshaller = _Xml.jaxbContextFor(dtoClass, writeOptions.useContextCache).createMarshaller();
        if (writeOptions.isFormattedOutput()) {
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        if (writeOptions.isAllowMissingRootElement() && !_Annotations.isPresent(dtoClass, XmlRootElement.class)) {
            QName qName = new QName("", dtoClass.getSimpleName());
            JAXBElement jaxbElement = new JAXBElement(qName, dtoClass, null, dto);
            marshaller.marshal((Object)jaxbElement, writer);
        } else {
            marshaller.marshal(dto, writer);
        }
    }

    private static <T> T _clone(@Nullable T dto) throws JAXBException {
        if (dto == null) {
            return dto;
        }
        Class type = (Class)_Casts.uncheckedCast(dto.getClass());
        StringWriter writer = new StringWriter();
        _Xml.writeXml(dto, writer, WriteOptions.builder().useContextCache(true).formattedOutput(false).allowMissingRootElement(true).build());
        StringReader reader = new StringReader(writer.toString());
        return _Xml._readXml(type, reader, ReadOptions.builder().useContextCache(true).allowMissingRootElement(true).build());
    }

    public static <T> Result<T> clone(@Nullable T dto) {
        return Result.of(() -> _Xml._clone(dto));
    }

    public static Exception verboseException(String doingWhat, @Nullable Class<?> dtoClass, Exception e) {
        String dtoClassName = Optional.ofNullable(dtoClass).map(Class::getName).orElse("unknown");
        if (_Xml.isIllegalAnnotationsException(e)) {
            try {
                List errors = (List)_Casts.uncheckedCast(e.getClass().getMethod("getErrors", new Class[0]).invoke((Object)e, new Object[0]));
                if (_NullSafe.size(errors) > 0) {
                    return _Exceptions.unrecoverable(String.format("Error %s, due to illegal annotations on object class '%s'; %d error(s) reported: %s", doingWhat, dtoClassName, errors.size(), errors.stream().map(Throwable::getMessage).collect(Collectors.joining("; "))), e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _Exceptions.unrecoverable(String.format("Error %s; object class is '%s'", doingWhat, dtoClassName), e);
    }

    private static boolean isIllegalAnnotationsException(Exception e) {
        return "com.sun.xml.bind.v2.runtime.IllegalAnnotationsException".equals(e.getClass().getName());
    }

    public static <T> JAXBContext jaxbContextFor(Class<T> dtoClass, boolean useCache) {
        return useCache ? jaxbContextByClass.computeIfAbsent(dtoClass, _Xml::contextOf) : _Xml.contextOf(dtoClass);
    }

    private static <T> JAXBContext contextOf(Class<T> dtoClass) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{dtoClass});
        }
        catch (Exception e) {
            throw _Xml.verboseException("obtaining JAXBContext for class", dtoClass, e);
        }
    }

    public static final class WriteOptions {
        private final boolean useContextCache;
        private final boolean formattedOutput;
        private final boolean allowMissingRootElement;

        public static WriteOptions defaults() {
            return WriteOptions.builder().build();
        }

        private static boolean $default$useContextCache() {
            return false;
        }

        private static boolean $default$formattedOutput() {
            return false;
        }

        private static boolean $default$allowMissingRootElement() {
            return false;
        }

        WriteOptions(boolean useContextCache, boolean formattedOutput, boolean allowMissingRootElement) {
            this.useContextCache = useContextCache;
            this.formattedOutput = formattedOutput;
            this.allowMissingRootElement = allowMissingRootElement;
        }

        public static WriteOptionsBuilder builder() {
            return new WriteOptionsBuilder();
        }

        public boolean isUseContextCache() {
            return this.useContextCache;
        }

        public boolean isFormattedOutput() {
            return this.formattedOutput;
        }

        public boolean isAllowMissingRootElement() {
            return this.allowMissingRootElement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WriteOptions)) {
                return false;
            }
            WriteOptions other = (WriteOptions)o;
            if (this.isUseContextCache() != other.isUseContextCache()) {
                return false;
            }
            if (this.isFormattedOutput() != other.isFormattedOutput()) {
                return false;
            }
            return this.isAllowMissingRootElement() == other.isAllowMissingRootElement();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseContextCache() ? 79 : 97);
            result = result * 59 + (this.isFormattedOutput() ? 79 : 97);
            result = result * 59 + (this.isAllowMissingRootElement() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "_Xml.WriteOptions(useContextCache=" + this.isUseContextCache() + ", formattedOutput=" + this.isFormattedOutput() + ", allowMissingRootElement=" + this.isAllowMissingRootElement() + ")";
        }

        public static class WriteOptionsBuilder {
            private boolean useContextCache$set;
            private boolean useContextCache$value;
            private boolean formattedOutput$set;
            private boolean formattedOutput$value;
            private boolean allowMissingRootElement$set;
            private boolean allowMissingRootElement$value;

            WriteOptionsBuilder() {
            }

            public WriteOptionsBuilder useContextCache(boolean useContextCache) {
                this.useContextCache$value = useContextCache;
                this.useContextCache$set = true;
                return this;
            }

            public WriteOptionsBuilder formattedOutput(boolean formattedOutput) {
                this.formattedOutput$value = formattedOutput;
                this.formattedOutput$set = true;
                return this;
            }

            public WriteOptionsBuilder allowMissingRootElement(boolean allowMissingRootElement) {
                this.allowMissingRootElement$value = allowMissingRootElement;
                this.allowMissingRootElement$set = true;
                return this;
            }

            public WriteOptions build() {
                boolean useContextCache$value = this.useContextCache$value;
                if (!this.useContextCache$set) {
                    useContextCache$value = WriteOptions.$default$useContextCache();
                }
                boolean formattedOutput$value = this.formattedOutput$value;
                if (!this.formattedOutput$set) {
                    formattedOutput$value = WriteOptions.$default$formattedOutput();
                }
                boolean allowMissingRootElement$value = this.allowMissingRootElement$value;
                if (!this.allowMissingRootElement$set) {
                    allowMissingRootElement$value = WriteOptions.$default$allowMissingRootElement();
                }
                return new WriteOptions(useContextCache$value, formattedOutput$value, allowMissingRootElement$value);
            }

            public String toString() {
                return "_Xml.WriteOptions.WriteOptionsBuilder(useContextCache$value=" + this.useContextCache$value + ", formattedOutput$value=" + this.formattedOutput$value + ", allowMissingRootElement$value=" + this.allowMissingRootElement$value + ")";
            }
        }
    }

    public static final class ReadOptions {
        private final boolean useContextCache;
        private final boolean allowMissingRootElement;

        public static ReadOptions defaults() {
            return ReadOptions.builder().build();
        }

        private static boolean $default$useContextCache() {
            return false;
        }

        private static boolean $default$allowMissingRootElement() {
            return false;
        }

        ReadOptions(boolean useContextCache, boolean allowMissingRootElement) {
            this.useContextCache = useContextCache;
            this.allowMissingRootElement = allowMissingRootElement;
        }

        public static ReadOptionsBuilder builder() {
            return new ReadOptionsBuilder();
        }

        public boolean isUseContextCache() {
            return this.useContextCache;
        }

        public boolean isAllowMissingRootElement() {
            return this.allowMissingRootElement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadOptions)) {
                return false;
            }
            ReadOptions other = (ReadOptions)o;
            if (this.isUseContextCache() != other.isUseContextCache()) {
                return false;
            }
            return this.isAllowMissingRootElement() == other.isAllowMissingRootElement();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseContextCache() ? 79 : 97);
            result = result * 59 + (this.isAllowMissingRootElement() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "_Xml.ReadOptions(useContextCache=" + this.isUseContextCache() + ", allowMissingRootElement=" + this.isAllowMissingRootElement() + ")";
        }

        public static class ReadOptionsBuilder {
            private boolean useContextCache$set;
            private boolean useContextCache$value;
            private boolean allowMissingRootElement$set;
            private boolean allowMissingRootElement$value;

            ReadOptionsBuilder() {
            }

            public ReadOptionsBuilder useContextCache(boolean useContextCache) {
                this.useContextCache$value = useContextCache;
                this.useContextCache$set = true;
                return this;
            }

            public ReadOptionsBuilder allowMissingRootElement(boolean allowMissingRootElement) {
                this.allowMissingRootElement$value = allowMissingRootElement;
                this.allowMissingRootElement$set = true;
                return this;
            }

            public ReadOptions build() {
                boolean useContextCache$value = this.useContextCache$value;
                if (!this.useContextCache$set) {
                    useContextCache$value = ReadOptions.$default$useContextCache();
                }
                boolean allowMissingRootElement$value = this.allowMissingRootElement$value;
                if (!this.allowMissingRootElement$set) {
                    allowMissingRootElement$value = ReadOptions.$default$allowMissingRootElement();
                }
                return new ReadOptions(useContextCache$value, allowMissingRootElement$value);
            }

            public String toString() {
                return "_Xml.ReadOptions.ReadOptionsBuilder(useContextCache$value=" + this.useContextCache$value + ", allowMissingRootElement$value=" + this.allowMissingRootElement$value + ")";
            }
        }
    }
}

