/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import lombok.NonNull;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Refs;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.springframework.lang.Nullable;

public final class ResourceCoordinates
implements Comparable<ResourceCoordinates> {
    @NonNull
    private final Can<String> location;
    @NonNull
    private final Can<String> namespace;
    @NonNull
    private final Can<String> name;
    @NonNull
    private final String nameAsString;
    @NonNull
    private final String simpleName;
    @NonNull
    private final String friendlyName;
    private static final Comparator<ResourceCoordinates> comparator = Comparator.comparing(ResourceCoordinates::getLocation).thenComparing(ResourceCoordinates::getNamespace).thenComparing(ResourceCoordinates::getName);

    public static ResourceCoordinates fromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ArrayList parts = _Lists.newArrayList();
        for (File next = file; next != null; next = next.getParentFile()) {
            if (!_Strings.isNotEmpty(next.getName())) continue;
            parts.add(next.getName());
        }
        _Refs.StringReference nameRef = _Refs.stringRef(file.getName());
        String simpleName = nameRef.cutAtLastIndexOfAndDrop(".");
        String fileNameExtension = nameRef.getValue();
        return ResourceCoordinates.builder().location(Can.empty()).simpleName(simpleName).friendlyName(simpleName).name(_Strings.isEmpty(fileNameExtension) ? Can.ofSingleton(simpleName) : Can.of(simpleName, fileNameExtension)).nameAsString(file.getName()).namespace(Can.ofStream(parts.stream().skip(1L)).reverse()).build();
    }

    @Override
    public int compareTo(@Nullable ResourceCoordinates other) {
        if (other == null) {
            return 1;
        }
        return comparator.compare(this, other);
    }

    ResourceCoordinates(@NonNull Can<String> location, @NonNull Can<String> namespace, @NonNull Can<String> name, @NonNull String nameAsString, @NonNull String simpleName, @NonNull String friendlyName) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (nameAsString == null) {
            throw new NullPointerException("nameAsString is marked non-null but is null");
        }
        if (simpleName == null) {
            throw new NullPointerException("simpleName is marked non-null but is null");
        }
        if (friendlyName == null) {
            throw new NullPointerException("friendlyName is marked non-null but is null");
        }
        this.location = location;
        this.namespace = namespace;
        this.name = name;
        this.nameAsString = nameAsString;
        this.simpleName = simpleName;
        this.friendlyName = friendlyName;
    }

    public static ResourceCoordinatesBuilder builder() {
        return new ResourceCoordinatesBuilder();
    }

    @NonNull
    public Can<String> getLocation() {
        return this.location;
    }

    @NonNull
    public Can<String> getNamespace() {
        return this.namespace;
    }

    @NonNull
    public Can<String> getName() {
        return this.name;
    }

    @NonNull
    public String getNameAsString() {
        return this.nameAsString;
    }

    @NonNull
    public String getSimpleName() {
        return this.simpleName;
    }

    @NonNull
    public String getFriendlyName() {
        return this.friendlyName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceCoordinates)) {
            return false;
        }
        ResourceCoordinates other = (ResourceCoordinates)o;
        Can<String> this$location = this.getLocation();
        Can<String> other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        Can<String> this$namespace = this.getNamespace();
        Can<String> other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        Can<String> this$name = this.getName();
        Can<String> other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$nameAsString = this.getNameAsString();
        String other$nameAsString = other.getNameAsString();
        if (this$nameAsString == null ? other$nameAsString != null : !this$nameAsString.equals(other$nameAsString)) {
            return false;
        }
        String this$simpleName = this.getSimpleName();
        String other$simpleName = other.getSimpleName();
        if (this$simpleName == null ? other$simpleName != null : !this$simpleName.equals(other$simpleName)) {
            return false;
        }
        String this$friendlyName = this.getFriendlyName();
        String other$friendlyName = other.getFriendlyName();
        return !(this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Can<String> $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        Can<String> $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        Can<String> $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $nameAsString = this.getNameAsString();
        result = result * 59 + ($nameAsString == null ? 43 : $nameAsString.hashCode());
        String $simpleName = this.getSimpleName();
        result = result * 59 + ($simpleName == null ? 43 : $simpleName.hashCode());
        String $friendlyName = this.getFriendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceCoordinates(location=" + this.getLocation() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", nameAsString=" + this.getNameAsString() + ", simpleName=" + this.getSimpleName() + ", friendlyName=" + this.getFriendlyName() + ")";
    }

    public static class ResourceCoordinatesBuilder {
        private Can<String> location;
        private Can<String> namespace;
        private Can<String> name;
        private String nameAsString;
        private String simpleName;
        private String friendlyName;

        ResourceCoordinatesBuilder() {
        }

        public ResourceCoordinatesBuilder location(@NonNull Can<String> location) {
            if (location == null) {
                throw new NullPointerException("location is marked non-null but is null");
            }
            this.location = location;
            return this;
        }

        public ResourceCoordinatesBuilder namespace(@NonNull Can<String> namespace) {
            if (namespace == null) {
                throw new NullPointerException("namespace is marked non-null but is null");
            }
            this.namespace = namespace;
            return this;
        }

        public ResourceCoordinatesBuilder name(@NonNull Can<String> name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ResourceCoordinatesBuilder nameAsString(@NonNull String nameAsString) {
            if (nameAsString == null) {
                throw new NullPointerException("nameAsString is marked non-null but is null");
            }
            this.nameAsString = nameAsString;
            return this;
        }

        public ResourceCoordinatesBuilder simpleName(@NonNull String simpleName) {
            if (simpleName == null) {
                throw new NullPointerException("simpleName is marked non-null but is null");
            }
            this.simpleName = simpleName;
            return this;
        }

        public ResourceCoordinatesBuilder friendlyName(@NonNull String friendlyName) {
            if (friendlyName == null) {
                throw new NullPointerException("friendlyName is marked non-null but is null");
            }
            this.friendlyName = friendlyName;
            return this;
        }

        public ResourceCoordinates build() {
            return new ResourceCoordinates(this.location, this.namespace, this.name, this.nameAsString, this.simpleName, this.friendlyName);
        }

        public String toString() {
            return "ResourceCoordinates.ResourceCoordinatesBuilder(location=" + this.location + ", namespace=" + this.namespace + ", name=" + this.name + ", nameAsString=" + this.nameAsString + ", simpleName=" + this.simpleName + ", friendlyName=" + this.friendlyName + ")";
        }
    }
}

