/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.applib.services;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.query.BooleanExpression;
import org.springframework.lang.Nullable;

public interface JdoSupportService {
    public PersistenceManagerFactory getPersistenceManagerFactory();

    public <T> T refresh(T var1);

    public void ensureLoaded(Collection<?> var1);

    public List<Map<String, Object>> executeSql(String var1);

    public Integer executeUpdate(String var1);

    public void deleteAll(Class<?> ... var1);

    public <T> List<T> executeQuery(Class<T> var1, @Nullable BooleanExpression var2);

    default public <T> List<T> executeQuery(Class<T> cls) {
        return this.executeQuery(cls, null);
    }

    public <T> T executeQueryUnique(Class<T> var1, @Nullable BooleanExpression var2);

    default public <T> T executeQueryUnique(Class<T> cls) {
        return this.executeQueryUnique(cls, null);
    }

    public <T> JDOQLTypedQuery<T> newTypesafeQuery(Class<T> var1);

    default public void disableMultivaluedFetch(JDOQLTypedQuery<?> query) {
        query.extension("datanucleus.rdbms.query.multivaluedFetch", (Object)"none");
    }

    default public void disableMultivaluedFetch(Query<?> query) {
        query.addExtension("datanucleus.rdbms.query.multivaluedFetch", (Object)"none");
    }

    default public PersistenceManager getPersistenceManager() {
        return this.getPersistenceManagerFactory().getPersistenceManager();
    }
}

