/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Map;
import javax.inject.Provider;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.sql.DataSource;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.config.beans.IsisBeanTypeRegistry;
import org.apache.isis.core.config.beans.aoppatch.TransactionInterceptorFactory;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.transaction.changetracking.EntityChangeTracker;
import org.apache.isis.persistence.jdo.datanucleus.changetracking.JdoLifecycleListener;
import org.apache.isis.persistence.jdo.datanucleus.config.DnEntityDiscoveryListener;
import org.apache.isis.persistence.jdo.datanucleus.config.DnSettings;
import org.apache.isis.persistence.jdo.datanucleus.dialect.DnJdoDialect;
import org.apache.isis.persistence.jdo.datanucleus.entities.DnEntityStateProvider;
import org.apache.isis.persistence.jdo.datanucleus.jdosupport.JdoSupportServiceDefault;
import org.apache.isis.persistence.jdo.datanucleus.mixins.Persistable_datanucleusVersionLong;
import org.apache.isis.persistence.jdo.datanucleus.mixins.Persistable_datanucleusVersionTimestamp;
import org.apache.isis.persistence.jdo.datanucleus.mixins.Persistable_downloadJdoMetadata;
import org.apache.isis.persistence.jdo.integration.IsisModulePersistenceJdoIntegration;
import org.apache.isis.persistence.jdo.spring.integration.JdoDialect;
import org.apache.isis.persistence.jdo.spring.integration.JdoTransactionManager;
import org.apache.isis.persistence.jdo.spring.integration.LocalPersistenceManagerFactoryBean;
import org.apache.isis.persistence.jdo.spring.integration.TransactionAwarePersistenceManagerFactoryProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@Import(value={IsisModulePersistenceJdoIntegration.class, DnEntityDiscoveryListener.class, DnEntityStateProvider.class, Persistable_datanucleusVersionLong.class, Persistable_datanucleusVersionTimestamp.class, Persistable_downloadJdoMetadata.class, JdoSupportServiceDefault.class})
@EnableConfigurationProperties(value={DnSettings.class})
public class IsisModulePersistenceJdoDatanucleus {
    private static final Logger log = LogManager.getLogger(IsisModulePersistenceJdoDatanucleus.class);

    @Qualifier(value="jdo-dialect")
    @Bean
    public DnJdoDialect getDnJdoDialect(DataSource dataSource) {
        return new DnJdoDialect(dataSource);
    }

    @Qualifier(value="local-pmf-proxy")
    @Bean
    public LocalPersistenceManagerFactoryBean getLocalPersistenceManagerFactoryBean(IsisConfiguration isisConfiguration, final DataSource dataSource, final MetaModelContext metaModelContext, final EventBusService eventBusService, final Provider<EntityChangeTracker> entityChangeTrackerProvider, final IsisBeanTypeRegistry beanTypeRegistry, DnSettings dnSettings) {
        _Assert.assertNotNull((Object)dataSource, (String)"a datasource is required");
        IsisModulePersistenceJdoDatanucleus.autoCreateSchemas(dataSource, isisConfiguration);
        LocalPersistenceManagerFactoryBean lpmfBean = new LocalPersistenceManagerFactoryBean(){

            protected PersistenceManagerFactory newPersistenceManagerFactory(Map<?, ?> props) {
                PersistenceUnitMetaData pu = IsisModulePersistenceJdoDatanucleus.createDefaultPersistenceUnit(beanTypeRegistry);
                JDOPersistenceManagerFactory pmf = new JDOPersistenceManagerFactory(pu, props);
                pmf.setConnectionFactory((Object)dataSource);
                IsisModulePersistenceJdoDatanucleus.integrateWithApplicationLayer(metaModelContext, eventBusService, (Provider<EntityChangeTracker>)entityChangeTrackerProvider, (PersistenceManagerFactory)pmf);
                return pmf;
            }

            protected PersistenceManagerFactory newPersistenceManagerFactory(String name) {
                PersistenceManagerFactory pmf = super.newPersistenceManagerFactory(name);
                pmf.setConnectionFactory((Object)dataSource);
                IsisModulePersistenceJdoDatanucleus.integrateWithApplicationLayer(metaModelContext, eventBusService, (Provider<EntityChangeTracker>)entityChangeTrackerProvider, pmf);
                return pmf;
            }
        };
        lpmfBean.setJdoPropertyMap(dnSettings.getAsProperties());
        return lpmfBean;
    }

    @Qualifier(value="transaction-aware-pmf-proxy")
    @Bean
    @Primary
    public TransactionAwarePersistenceManagerFactoryProxy getTransactionAwarePersistenceManagerFactoryProxy(MetaModelContext metaModelContext, @Qualifier(value="local-pmf-proxy") LocalPersistenceManagerFactoryBean localPmfBean) {
        PersistenceManagerFactory pmf = localPmfBean.getObject();
        TransactionAwarePersistenceManagerFactoryProxy tapmfProxy = new TransactionAwarePersistenceManagerFactoryProxy(metaModelContext);
        tapmfProxy.setTargetPersistenceManagerFactory(pmf);
        tapmfProxy.setAllowCreate(false);
        return tapmfProxy;
    }

    @Qualifier(value="jdo-platform-transaction-manager")
    @Bean
    @Primary
    public JdoTransactionManager getTransactionManager(@Qualifier(value="jdo-dialect") JdoDialect jdoDialect, @Qualifier(value="local-pmf-proxy") LocalPersistenceManagerFactoryBean localPmfBean) {
        PersistenceManagerFactory pmf = localPmfBean.getObject();
        JdoTransactionManager txManager = new JdoTransactionManager(pmf);
        txManager.setJdoDialect(jdoDialect);
        return txManager;
    }

    @Bean
    @Primary
    public TransactionInterceptorFactory getTransactionInterceptorFactory() {
        return () -> new TransactionInterceptor(){

            protected void completeTransactionAfterThrowing(TransactionAspectSupport.TransactionInfo txInfo, Throwable ex) {
                PlatformTransactionManager txManager;
                super.completeTransactionAfterThrowing(txInfo, ex);
                if (ex instanceof RuntimeException && (txManager = txInfo.getTransactionManager()) instanceof JdoTransactionManager) {
                    DataAccessException translatedEx;
                    JdoDialect jdoDialect = ((JdoTransactionManager)txManager).getJdoDialect();
                    if (jdoDialect instanceof PersistenceExceptionTranslator && (translatedEx = ((PersistenceExceptionTranslator)jdoDialect).translateExceptionIfPossible((RuntimeException)ex)) != null) {
                        throw translatedEx;
                    }
                    if (ex instanceof JDOException && (translatedEx = jdoDialect.translateException((JDOException)ex)) != null) {
                        throw translatedEx;
                    }
                }
            }
        };
    }

    private static DataSource autoCreateSchemas(DataSource dataSource, IsisConfiguration isisConfiguration) {
        IsisConfiguration.Persistence.Schema persistenceSchemaConf = isisConfiguration.getPersistence().getSchema();
        if (!persistenceSchemaConf.getAutoCreateSchemas().isEmpty()) {
            log.info("About to create db schema(s) {} with template '{}'", (Object)persistenceSchemaConf.getAutoCreateSchemas(), (Object)persistenceSchemaConf.getCreateSchemaSqlTemplate());
            try (Connection con = dataSource.getConnection();){
                Statement s = con.createStatement();
                for (String schema : persistenceSchemaConf.getAutoCreateSchemas()) {
                    String sql = String.format(persistenceSchemaConf.getCreateSchemaSqlTemplate(), schema);
                    log.info("SQL '{}'", (Object)sql);
                    s.execute(sql);
                }
            }
        }
        return dataSource;
    }

    private static PersistenceUnitMetaData createDefaultPersistenceUnit(IsisBeanTypeRegistry beanTypeRegistry) {
        PersistenceUnitMetaData pumd = new PersistenceUnitMetaData("dynamic-unit", "RESOURCE_LOCAL", null);
        pumd.setExcludeUnlistedClasses(false);
        beanTypeRegistry.getEntityTypes().stream().map(Class::getName).forEach(arg_0 -> ((PersistenceUnitMetaData)pumd).addClassName(arg_0));
        return pumd;
    }

    private static void integrateWithApplicationLayer(MetaModelContext metaModelContext, EventBusService eventBusService, Provider<EntityChangeTracker> entityChangeTrackerProvider, PersistenceManagerFactory pmf) {
        JdoLifecycleListener jdoLifecycleListener = new JdoLifecycleListener(metaModelContext, eventBusService, entityChangeTrackerProvider);
        pmf.addInstanceLifecycleListener((InstanceLifecycleListener)jdoLifecycleListener, (Class[])null);
    }
}

