/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.changetracking;

import javax.enterprise.inject.Vetoed;
import javax.inject.Provider;
import javax.jdo.listener.AttachLifecycleListener;
import javax.jdo.listener.ClearLifecycleListener;
import javax.jdo.listener.CreateLifecycleListener;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.DetachLifecycleListener;
import javax.jdo.listener.DirtyLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.LoadLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import lombok.NonNull;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.objectmanager.ObjectManager;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.transaction.changetracking.EntityChangeTracker;
import org.apache.isis.core.transaction.changetracking.events.PostStoreEvent;
import org.apache.isis.core.transaction.changetracking.events.PreStoreEvent;
import org.apache.isis.persistence.jdo.datanucleus.changetracking._Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.datanucleus.enhancement.Persistable;

@Vetoed
public class JdoLifecycleListener
implements AttachLifecycleListener,
ClearLifecycleListener,
CreateLifecycleListener,
DeleteLifecycleListener,
DetachLifecycleListener,
DirtyLifecycleListener,
LoadLifecycleListener,
StoreLifecycleListener {
    private static final Logger log = LogManager.getLogger(JdoLifecycleListener.class);
    @NonNull
    private final MetaModelContext metaModelContext;
    @NonNull
    private final EventBusService eventBusService;
    @NonNull
    private final Provider<EntityChangeTracker> entityChangeTrackerProvider;

    public void postCreate(InstanceLifecycleEvent event) {
        log.debug("postCreate {}", new Supplier[]{() -> _Utils.debug(event)});
        _Utils.resolveInjectionPoints(this.metaModelContext, event);
    }

    public void preAttach(InstanceLifecycleEvent event) {
        log.debug("preAttach {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void postAttach(InstanceLifecycleEvent event) {
        log.debug("postAttach {}", new Supplier[]{() -> _Utils.debug(event)});
        _Utils.resolveInjectionPoints(this.metaModelContext, event);
    }

    public void postLoad(InstanceLifecycleEvent event) {
        log.debug("postLoad {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        ManagedObject entity = this.adaptEntityAndInjectServices(pojo, ObjectManager.EntityAdaptingMode.MEMOIZE_BOOKMARK);
        this.getEntityChangeTracker().recognizeLoaded(entity);
    }

    public void preStore(InstanceLifecycleEvent event) {
        log.debug("preStore {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        this.eventBusService.post((Object)PreStoreEvent.of((Object)pojo));
        if (pojo.dnGetStateManager().isNew(pojo)) {
            ManagedObject entity = this.adaptEntity(pojo, ObjectManager.EntityAdaptingMode.SKIP_MEMOIZATION);
            this.getEntityChangeTracker().recognizePersisting(entity);
        }
    }

    public void postStore(InstanceLifecycleEvent event) {
        log.debug("postStore {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        ManagedObject entity = this.adaptEntityAndInjectServices(pojo, ObjectManager.EntityAdaptingMode.MEMOIZE_BOOKMARK);
        this.eventBusService.post((Object)PostStoreEvent.of((Object)pojo));
        if (pojo.dnGetStateManager().isNew(pojo)) {
            this.getEntityChangeTracker().enlistCreated(entity);
        } else {
            this.getEntityChangeTracker().recognizeUpdating(entity);
        }
    }

    public void preDirty(InstanceLifecycleEvent event) {
        log.debug("preDirty {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        ManagedObject entity = this.adaptEntity(pojo, ObjectManager.EntityAdaptingMode.MEMOIZE_BOOKMARK);
        this.getEntityChangeTracker().enlistUpdating(entity);
    }

    public void postDirty(InstanceLifecycleEvent event) {
        log.debug("postDirty {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void preDelete(InstanceLifecycleEvent event) {
        log.debug("preDelete {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        ManagedObject entity = this.adaptEntity(pojo, ObjectManager.EntityAdaptingMode.SKIP_MEMOIZATION);
        this.getEntityChangeTracker().enlistDeleting(entity);
    }

    public void postDelete(InstanceLifecycleEvent event) {
        log.debug("postDelete {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void preClear(InstanceLifecycleEvent event) {
        log.debug("preClear {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void postClear(InstanceLifecycleEvent event) {
        log.debug("postClear {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void preDetach(InstanceLifecycleEvent event) {
        log.debug("preDetach {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void postDetach(InstanceLifecycleEvent event) {
        log.debug("postDetach {}", new Supplier[]{() -> _Utils.debug(event)});
        _Utils.resolveInjectionPoints(this.metaModelContext, event);
    }

    private ManagedObject adaptEntity(@NonNull Persistable pojo, @NonNull ObjectManager.EntityAdaptingMode bookmarking) {
        if (pojo == null) {
            throw new NullPointerException("pojo is marked non-null but is null");
        }
        if (bookmarking == null) {
            throw new NullPointerException("bookmarking is marked non-null but is null");
        }
        return _Utils.adaptEntity(this.metaModelContext, pojo, bookmarking);
    }

    private ManagedObject adaptEntityAndInjectServices(@NonNull Persistable pojo, @NonNull ObjectManager.EntityAdaptingMode bookmarking) {
        if (pojo == null) {
            throw new NullPointerException("pojo is marked non-null but is null");
        }
        if (bookmarking == null) {
            throw new NullPointerException("bookmarking is marked non-null but is null");
        }
        return _Utils.adaptEntityAndInjectServices(this.metaModelContext, pojo, bookmarking);
    }

    private EntityChangeTracker getEntityChangeTracker() {
        return (EntityChangeTracker)this.entityChangeTrackerProvider.get();
    }

    public JdoLifecycleListener(@NonNull MetaModelContext metaModelContext, @NonNull EventBusService eventBusService, @NonNull Provider<EntityChangeTracker> entityChangeTrackerProvider) {
        if (metaModelContext == null) {
            throw new NullPointerException("metaModelContext is marked non-null but is null");
        }
        if (eventBusService == null) {
            throw new NullPointerException("eventBusService is marked non-null but is null");
        }
        if (entityChangeTrackerProvider == null) {
            throw new NullPointerException("entityChangeTrackerProvider is marked non-null but is null");
        }
        this.metaModelContext = metaModelContext;
        this.eventBusService = eventBusService;
        this.entityChangeTrackerProvider = entityChangeTrackerProvider;
    }
}

