/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.changetracking;

import javax.jdo.JDOHelper;
import javax.jdo.ObjectState;
import javax.jdo.listener.InstanceLifecycleEvent;
import lombok.NonNull;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.objectmanager.ObjectManager;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.datanucleus.enhancement.Persistable;
import org.springframework.lang.Nullable;

final class _Utils {
    static Persistable persistableFor(InstanceLifecycleEvent event) {
        return (Persistable)event.getPersistentInstance();
    }

    static void resolveInjectionPoints(@NonNull MetaModelContext mmc, @NonNull InstanceLifecycleEvent event) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        Persistable pojo = _Utils.persistableFor(event);
        if (pojo != null) {
            mmc.getServiceInjector().injectServicesInto((Object)pojo);
        }
    }

    static String debug(InstanceLifecycleEvent event) {
        Persistable pojo = _Utils.persistableFor(event);
        ObjectState state = JDOHelper.getObjectState((Object)pojo);
        return String.format("entity: %s (%s)", pojo.getClass().getSimpleName(), state);
    }

    static ManagedObject adaptEntity(@NonNull MetaModelContext mmc, @NonNull Object entityPojo, @NonNull ObjectManager.EntityAdaptingMode bookmarking) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (entityPojo == null) {
            throw new NullPointerException("entityPojo is marked non-null but is null");
        }
        if (bookmarking == null) {
            throw new NullPointerException("bookmarking is marked non-null but is null");
        }
        ObjectManager objectManager = mmc.getObjectManager();
        ManagedObject entity = objectManager.adapt(entityPojo, bookmarking);
        _Assert.assertTrue((boolean)entity.getSpecification().isEntity());
        return entity;
    }

    static ManagedObject adaptNullableEntity(@NonNull MetaModelContext mmc, @Nullable Object entityPojo, @NonNull ObjectManager.EntityAdaptingMode bookmarking) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (bookmarking == null) {
            throw new NullPointerException("bookmarking is marked non-null but is null");
        }
        return entityPojo == null ? ManagedObject.unspecified() : _Utils.adaptEntity(mmc, entityPojo, bookmarking);
    }

    static ManagedObject adaptNullableAndInjectServices(@NonNull MetaModelContext mmc, @Nullable Object entityPojo, @NonNull ObjectManager.EntityAdaptingMode bookmarking) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (bookmarking == null) {
            throw new NullPointerException("bookmarking is marked non-null but is null");
        }
        return entityPojo == null ? ManagedObject.unspecified() : _Utils.adaptEntityAndInjectServices(mmc, entityPojo, bookmarking);
    }

    static ManagedObject adaptEntityAndInjectServices(@NonNull MetaModelContext mmc, @NonNull Object entityPojo, @NonNull ObjectManager.EntityAdaptingMode bookmarking) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (entityPojo == null) {
            throw new NullPointerException("entityPojo is marked non-null but is null");
        }
        if (bookmarking == null) {
            throw new NullPointerException("bookmarking is marked non-null but is null");
        }
        return _Utils.injectServices(mmc, _Utils.adaptEntity(mmc, entityPojo, bookmarking));
    }

    private static ManagedObject injectServices(@NonNull MetaModelContext mmc, @NonNull ManagedObject adapter) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (adapter == null) {
            throw new NullPointerException("adapter is marked non-null but is null");
        }
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)adapter)) {
            return adapter;
        }
        if (adapter.getSpecification().isValue()) {
            return adapter;
        }
        mmc.getServiceInjector().injectServicesInto(adapter.getPojo());
        return adapter;
    }

    private _Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

