/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.config;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jdo.PersistenceManagerFactory;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.persistence.jdo.provider.config.JdoEntityDiscoveryListener;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.springframework.stereotype.Component;

@Component
public class DnEntityDiscoveryListener
implements JdoEntityDiscoveryListener {
    public void onEntitiesDiscovered(@NonNull PersistenceManagerFactory persistenceManagerFactory, @NonNull Set<Class<?>> entityTypes, @NonNull Map<String, String> dnSettings) {
        if (persistenceManagerFactory == null) {
            throw new NullPointerException("persistenceManagerFactory is marked non-null but is null");
        }
        if (entityTypes == null) {
            throw new NullPointerException("entityTypes is marked non-null but is null");
        }
        if (dnSettings == null) {
            throw new NullPointerException("dnSettings is marked non-null but is null");
        }
        if (_NullSafe.isEmpty(entityTypes)) {
            return;
        }
        JDOPersistenceManagerFactory pmf = (JDOPersistenceManagerFactory)persistenceManagerFactory;
        PersistenceNucleusContext nucleusContext = pmf.getNucleusContext();
        SchemaAwareStoreManager schemaAwareStoreManager = (SchemaAwareStoreManager)nucleusContext.getStoreManager();
        Set classNames = entityTypes.stream().map(Class::getName).collect(Collectors.toSet());
        Properties properties = new Properties();
        properties.putAll(dnSettings);
        schemaAwareStoreManager.createSchemaForClasses(classNames, properties);
        ClassLoaderResolver clr = nucleusContext.getClassLoaderResolver(_Context.getDefaultClassLoader());
        MetaDataManager metaDataManager = nucleusContext.getMetaDataManager();
        metaDataManager.getClassesWithMetaData().forEach(className -> {
            AbstractClassMetaData meta = metaDataManager.getMetaDataForClass(className, clr);
            _NullSafe.stream((Object[])meta.getQueries()).forEach(arg_0 -> ((MetaDataManager)metaDataManager).registerNamedQuery(arg_0));
        });
    }
}

