/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.isis.persistence.jdo.datanucleus.entities.DnObjectProviderForIsis;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@Named(value="isis.persistence.jdo.DnSettings")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Dn5")
@ConfigurationProperties(prefix="", ignoreUnknownFields=true)
public class DnSettings {
    private static final Logger log = LogManager.getLogger(DnSettings.class);
    private Map<String, String> datanucleus = Collections.emptyMap();
    private Map<String, String> javax = Collections.emptyMap();
    private final Object lock = new Object();
    private Map<String, Object> properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAsProperties() {
        Object object = this.lock;
        synchronized (object) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
                if (this.datanucleus != null) {
                    this.datanucleus.forEach((k, v) -> this.properties.put("datanucleus." + k, v));
                }
                if (this.javax != null) {
                    this.javax.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("jdo.")).forEach(e -> this.properties.put("javax." + (String)e.getKey(), e.getValue()));
                }
                this.amendProperties(this.properties);
            }
        }
        return this.properties;
    }

    private void amendProperties(Map<String, Object> props) {
        String connectionFactoryName = (String)props.get("datanucleus.ConnectionFactoryName");
        if (connectionFactoryName != null) {
            String connectionFactory2Name = (String)props.get("datanucleus.ConnectionFactory2Name");
            String transactionType = (String)props.get("javax.jdo.option.TransactionType");
            if (transactionType == null) {
                log.info("found config properties to use non-JTA JNDI datasource ({})", (Object)connectionFactoryName);
                if (connectionFactory2Name != null) {
                    log.warn("found config properties to use non-JTA JNDI datasource ({}); second '-nontx' JNDI datasource also configured but will not be used ({})", (Object)connectionFactoryName, (Object)connectionFactory2Name);
                }
            } else {
                log.info("found config properties to use JTA JNDI datasource ({})", (Object)connectionFactoryName);
            }
            if (connectionFactory2Name == null) {
                log.error("found config properties to use JTA JNDI datasource ({}) but config properties for second '-nontx' JNDI datasource were *not* found", (Object)connectionFactoryName);
            } else {
                log.info("... and config properties for second '-nontx' JNDI datasource also found; {}", (Object)connectionFactory2Name);
            }
        }
        props.computeIfAbsent("datanucleus.stateManager.className", key -> DnObjectProviderForIsis.class.getName());
    }

    public Map<String, String> getDatanucleus() {
        return this.datanucleus;
    }

    public void setDatanucleus(Map<String, String> datanucleus) {
        this.datanucleus = datanucleus;
    }

    public Map<String, String> getJavax() {
        return this.javax;
    }

    public void setJavax(Map<String, String> javax) {
        this.javax = javax;
    }
}

