/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.entities;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.isis.applib.services.repository.EntityState;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.entity.EntityFacet;
import org.apache.isis.persistence.jdo.datanucleus.metamodel.facets.entity.JdoEntityFacet;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;
import org.datanucleus.enhancement.Persistable;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class DnEntityStateProvider
implements JdoFacetContext {
    private static final Set<String> jdoMethodsProvidedByEnhancement = _Sets.newHashSet();

    public EntityState getEntityState(Object pojo) {
        return DnEntityStateProvider.entityState(pojo);
    }

    public boolean isPersistenceEnhanced(@Nullable Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Persistable.class.isAssignableFrom(cls);
    }

    public boolean isMethodProvidedByEnhancement(@Nullable Method method) {
        if (method == null) {
            return false;
        }
        DnEntityStateProvider.ensureInit();
        return jdoMethodsProvidedByEnhancement.contains(method.toString());
    }

    public static EntityState entityState(Object pojo) {
        if (pojo == null) {
            return EntityState.NOT_PERSISTABLE;
        }
        if (pojo != null && pojo instanceof Persistable) {
            Persistable persistable = (Persistable)pojo;
            boolean isDeleted = persistable.dnIsDeleted();
            if (isDeleted) {
                return EntityState.PERSISTABLE_REMOVED;
            }
            boolean isPersistent = persistable.dnIsPersistent();
            if (isPersistent) {
                return EntityState.PERSISTABLE_ATTACHED;
            }
            return EntityState.PERSISTABLE_DETACHED;
        }
        return EntityState.NOT_PERSISTABLE;
    }

    private static Method[] getMethodsProvidedByEnhancement() {
        return Persistable.class.getDeclaredMethods();
    }

    private static void ensureInit() {
        if (jdoMethodsProvidedByEnhancement.isEmpty()) {
            _NullSafe.stream((Object[])DnEntityStateProvider.getMethodsProvidedByEnhancement()).map(Method::toString).forEach(jdoMethodsProvidedByEnhancement::add);
        }
    }

    public EntityFacet createEntityFacet(FacetHolder facetHolder) {
        return new JdoEntityFacet(facetHolder);
    }
}

