/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.entities;

import java.util.Optional;
import javax.jdo.PersistenceManager;
import org.apache.isis.applib.services.inject.ServiceInjector;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.ExecutionContext;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ReferentialStateManagerImpl;
import org.datanucleus.store.FieldValues;

public class DnObjectProviderForIsis
extends ReferentialStateManagerImpl {
    private static final Logger log = LogManager.getLogger(DnObjectProviderForIsis.class);
    private ServiceInjector serviceInjector;

    public DnObjectProviderForIsis(ExecutionContext ec, AbstractClassMetaData cmd) {
        super(ec, cmd);
        this.serviceInjector = this.extractServiceInjectorFrom(ec).orElse(null);
    }

    public void initialiseForHollow(Object id, FieldValues fv, Class pcClass) {
        super.initialiseForHollow(id, fv, pcClass);
        this.injectServices(this.myPC);
    }

    public void initialiseForHollowAppId(FieldValues fv, Class pcClass) {
        super.initialiseForHollowAppId(fv, pcClass);
        this.injectServices(this.myPC);
    }

    public void initialiseForHollowPreConstructed(Object id, Persistable pc) {
        super.initialiseForHollowPreConstructed(id, pc);
        this.injectServices(this.myPC);
    }

    public void initialiseForPersistentClean(Object id, Persistable pc) {
        super.initialiseForPersistentClean(id, pc);
        this.injectServices(this.myPC);
    }

    public void initialiseForEmbedded(Persistable pc, boolean copyPc) {
        super.initialiseForEmbedded(pc, copyPc);
        this.injectServices(this.myPC);
    }

    public void initialiseForPersistentNew(Persistable pc, FieldValues preInsertChanges) {
        super.initialiseForPersistentNew(pc, preInsertChanges);
        this.injectServices(this.myPC);
    }

    public void initialiseForTransactionalTransient(Persistable pc) {
        super.initialiseForTransactionalTransient(pc);
        this.injectServices(this.myPC);
    }

    public void initialiseForDetached(Persistable pc, Object id, Object version) {
        super.initialiseForDetached(pc, id, version);
        this.injectServices(this.myPC);
    }

    public void initialiseForPNewToBeDeleted(Persistable pc) {
        super.initialiseForPNewToBeDeleted(pc);
        this.injectServices(this.myPC);
    }

    public void initialiseForCachedPC(CachedPC cachedPC, Object id) {
        super.initialiseForCachedPC(cachedPC, id);
        this.injectServices(this.myPC);
    }

    private Optional<ServiceInjector> extractServiceInjectorFrom(ExecutionContext ec) {
        Object pm = ec.getOwner();
        if (!(pm instanceof PersistenceManager)) {
            log.error("could not extract the current PersistenceManager from given ExecutionContext");
            return Optional.empty();
        }
        String mmcKey = "isis.mmc";
        Object mmc = ((PersistenceManager)pm).getUserObject((Object)"isis.mmc");
        if (!(mmc instanceof MetaModelContext)) {
            log.error("MetaModelContext, stored as key/value pair with key 'isis.mmc', was not found amoung current PersistenceManager's user objects");
            return Optional.empty();
        }
        ServiceInjector serviceInjector = ((MetaModelContext)mmc).getServiceInjector();
        if (serviceInjector == null) {
            log.error("could not find a usable ServiceInjector with given MetaModelContext");
            return Optional.empty();
        }
        return Optional.of(serviceInjector);
    }

    private void injectServices(Persistable entity) {
        if (entity == null) {
            return;
        }
        if (this.serviceInjector != null) {
            this.serviceInjector.injectServicesInto((Object)entity);
        } else {
            log.warn("cannot inject services into entity of type {}, as there is no ServiceInjector available", entity.getClass());
        }
    }
}

