/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.jdosupport;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jdo.Extent;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.query.BooleanExpression;
import org.apache.isis.applib.exceptions.UnrecoverableException;
import org.apache.isis.applib.exceptions.unrecoverable.ObjectPersistenceException;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.objectmanager.ObjectManager;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.persistence.jdo.applib.services.JdoSupportService;
import org.apache.isis.persistence.jdo.spring.integration.TransactionAwarePersistenceManagerFactoryProxy;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.persistence.jdo.JdoSupportServiceDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="DN5")
public class JdoSupportServiceDefault
implements JdoSupportService {
    @Inject
    private TransactionAwarePersistenceManagerFactoryProxy pmf;
    @Inject
    private MetaModelContext mmc;

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.pmf.getPersistenceManagerFactory();
    }

    public <T> T refresh(T domainObject) {
        ObjectManager objectManager = this.mmc.getObjectManager();
        ManagedObject adapter = this.mmc.getObjectManager().adapt(domainObject);
        objectManager.refreshObject(adapter);
        return domainObject;
    }

    public void ensureLoaded(Collection<?> domainObjects) {
        this.getPersistenceManager().retrieveAll(domainObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> executeSql(String sql) {
        try (JDOConnection dataStoreConnection = this.getPersistenceManager().getDataStoreConnection();){
            Object connectionObj = dataStoreConnection.getNativeConnection();
            if (!(connectionObj instanceof Connection)) {
                List<Map<String, Object>> list = null;
                return list;
            }
            Connection connection = (Connection)connectionObj;
            List<Map<String, Object>> list = JdoSupportServiceDefault.executeSql(connection, sql);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer executeUpdate(String sql) {
        try (JDOConnection dataStoreConnection = this.getPersistenceManager().getDataStoreConnection();){
            Object connectionObj = dataStoreConnection.getNativeConnection();
            if (!(connectionObj instanceof Connection)) {
                Integer n = null;
                return n;
            }
            Connection connection = (Connection)connectionObj;
            Integer n = JdoSupportServiceDefault.executeUpdate(connection, sql);
            return n;
        }
    }

    private static List<Map<String, Object>> executeSql(Connection connection, String sql) {
        ArrayList rows = _Lists.newArrayList();
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                LinkedHashMap row = _Maps.newLinkedHashMap();
                int columnCount = rsmd.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    Object val = rs.getObject(i + 1);
                    row.put(rsmd.getColumnName(i + 1), val);
                }
                rows.add(row);
            }
        }
        catch (SQLException ex) {
            throw new ObjectPersistenceException("Failed to executeSql: " + sql, (Throwable)ex);
        }
        return rows;
    }

    private static int executeUpdate(Connection connection, String sql) {
        int n;
        block8: {
            Statement statement = connection.createStatement();
            try {
                n = statement.executeUpdate(sql);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new ObjectPersistenceException("Failed to executeSql: " + sql, (Throwable)ex);
                }
            }
            statement.close();
        }
        return n;
    }

    public void deleteAll(Class<?> ... pcClasses) {
        for (Class<?> pcClass : pcClasses) {
            Extent extent = this.getPersistenceManager().getExtent(pcClass);
            List instances = _NullSafe.stream((Iterable)extent).collect(Collectors.toList());
            try {
                this.getPersistenceManager().deletePersistentAll(instances);
            }
            catch (Exception ex) {
                throw new UnrecoverableException((Throwable)ex);
            }
        }
    }

    public <T> List<T> executeQuery(Class<T> cls, BooleanExpression filter) {
        JDOQLTypedQuery query = this.newTypesafeQuery(cls);
        if (filter != null) {
            query = query.filter(filter);
        }
        return JdoSupportServiceDefault.executeListAndClose(query);
    }

    public <T> T executeQueryUnique(Class<T> cls, BooleanExpression filter) {
        JDOQLTypedQuery query = this.newTypesafeQuery(cls);
        if (filter != null) {
            query = query.filter(filter);
        }
        return JdoSupportServiceDefault.executeUniqueAndClose(query);
    }

    public <T> JDOQLTypedQuery<T> newTypesafeQuery(Class<T> cls) {
        return this.getPersistenceManager().newJDOQLTypedQuery(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> executeListAndClose(JDOQLTypedQuery<T> query) {
        try {
            ArrayList list;
            List elements = query.executeList();
            ArrayList arrayList = list = _Lists.newArrayList((Collection)elements);
            return arrayList;
        }
        finally {
            query.closeAll();
        }
    }

    private static <T> T executeUniqueAndClose(JDOQLTypedQuery<T> query) {
        try {
            Object result;
            Object object = result = query.executeUnique();
            return (T)object;
        }
        finally {
            query.closeAll();
        }
    }

    public void disableMultivaluedFetch(JDOQLTypedQuery<?> query) {
        query.extension("datanucleus.rdbms.query.multivaluedFetch", (Object)"none");
    }

    public void disableMultivaluedFetch(Query<?> query) {
        query.addExtension("datanucleus.rdbms.query.multivaluedFetch", (Object)"none");
    }
}

