/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.metamodel.facets.entity;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.jdo.FetchPlan;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.PersistenceManager;
import lombok.NonNull;
import org.apache.isis.applib.exceptions.unrecoverable.ObjectNotFoundException;
import org.apache.isis.applib.query.AllInstancesQuery;
import org.apache.isis.applib.query.NamedQuery;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryRange;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.Oid;
import org.apache.isis.applib.services.exceprecog.Category;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.isis.applib.services.exceprecog.Recognition;
import org.apache.isis.applib.services.inject.ServiceInjector;
import org.apache.isis.applib.services.repository.EntityState;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.applib.services.xactn.TransactionalProcessor;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.debug._Debug;
import org.apache.isis.commons.internal.debug.xray.XrayUi;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.entity.EntityFacet;
import org.apache.isis.core.metamodel.facets.object.entity.PersistenceStandard;
import org.apache.isis.core.metamodel.objectmanager.ObjectManager;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.transaction.changetracking.EntityChangeTracker;
import org.apache.isis.persistence.jdo.datanucleus.entities.DnEntityStateProvider;
import org.apache.isis.persistence.jdo.datanucleus.oid.JdoObjectIdSerializer;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;
import org.apache.isis.persistence.jdo.spring.integration.TransactionAwarePersistenceManagerFactoryProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.enhancement.Persistable;

public class JdoEntityFacet
extends FacetAbstract
implements EntityFacet {
    private static final Logger log = LogManager.getLogger(JdoEntityFacet.class);
    @Inject
    private TransactionAwarePersistenceManagerFactoryProxy pmf;
    @Inject
    private TransactionService txService;
    @Inject
    private ObjectManager objectManager;
    @Inject
    private ExceptionRecognizerService exceptionRecognizerService;
    @Inject
    private JdoFacetContext jdoFacetContext;

    public JdoEntityFacet(FacetHolder holder) {
        super(EntityFacet.class, holder);
    }

    public PersistenceStandard getPersistenceStandard() {
        return PersistenceStandard.JDO;
    }

    public String identifierFor(ObjectSpecification spec, Object pojo) {
        if (pojo == null) {
            throw _Exceptions.illegalArgument((String)"The persistence layer cannot identify a pojo that is null (given type %s)", (Object[])new Object[]{spec.getCorrespondingClass().getName()});
        }
        if (!JdoEntityFacet.isPersistableType(pojo.getClass())) {
            throw _Exceptions.illegalArgument((String)"The persistence layer does not recognize given type %s", (Object[])new Object[]{pojo.getClass().getName()});
        }
        PersistenceManager pm = this.getPersistenceManager();
        Object primaryKey = pm.getObjectId(pojo);
        if (primaryKey == null) {
            _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"detached entity detected %s", (Object[])new Object[]{pojo}));
            throw _Exceptions.illegalArgument((String)"The persistence layer does not recognize given object of type %s, meaning the object has no identifier that associates it with the persistence layer. (most likely, because the object is detached, eg. was not persisted after being new-ed up)", (Object[])new Object[]{pojo.getClass().getName()});
        }
        String identifier = JdoObjectIdSerializer.toOidIdentifier(primaryKey);
        if (_Strings.isEmpty((CharSequence)identifier)) {
            throw _Exceptions.illegalArgument((String)"JdoObjectIdSerializer failed to convert primary key %s to a String.", (Object[])new Object[]{primaryKey.getClass().getName()});
        }
        return identifier;
    }

    public ManagedObject fetchByIdentifier(@NonNull ObjectSpecification entitySpec, @NonNull Bookmark bookmark) {
        Object entityPojo;
        if (entitySpec == null) {
            throw new NullPointerException("entitySpec is marked non-null but is null");
        }
        if (bookmark == null) {
            throw new NullPointerException("bookmark is marked non-null but is null");
        }
        _Assert.assertTrue((boolean)entitySpec.isEntity());
        log.debug("fetchEntity; bookmark={}", (Object)bookmark);
        try {
            Object primaryKey = JdoObjectIdSerializer.toJdoObjectId(entitySpec, (Oid)bookmark);
            PersistenceManager persistenceManager = this.getPersistenceManager();
            Class entityClass = entitySpec.getCorrespondingClass();
            FetchPlan fetchPlan = persistenceManager.getFetchPlan();
            fetchPlan.addGroup("default");
            entityPojo = persistenceManager.getObjectById(entityClass, primaryKey);
        }
        catch (RuntimeException e) {
            Optional recognition = this.exceptionRecognizerService.recognize((Throwable)e);
            if (recognition.isPresent() && ((Recognition)recognition.get()).getCategory() == Category.NOT_FOUND) {
                throw new ObjectNotFoundException("" + bookmark, (Throwable)e);
            }
            throw e;
        }
        if (entityPojo == null) {
            throw new ObjectNotFoundException("" + bookmark);
        }
        ObjectSpecification actualEntitySpec = this.getSpecificationLoader().specForTypeElseFail(entityPojo.getClass());
        this.getServiceInjector().injectServicesInto(entityPojo);
        return ManagedObject.bookmarked((ObjectSpecification)actualEntitySpec, (Object)entityPojo, (Bookmark)bookmark);
    }

    public Can<ManagedObject> fetchByQuery(ObjectSpecification spec, Query<?> query) {
        if (!spec.isEntity()) {
            throw _Exceptions.unexpectedCodeReach();
        }
        if (log.isDebugEnabled()) {
            log.debug("about to execute Query: {}", (Object)query.getDescription());
        }
        QueryRange range = query.getRange();
        if (query instanceof AllInstancesQuery) {
            AllInstancesQuery queryFindAllInstances = (AllInstancesQuery)query;
            Class queryEntityType = queryFindAllInstances.getResultType();
            PersistenceManager persistenceManager = this.getPersistenceManager();
            JDOQLTypedQuery typedQuery = persistenceManager.newJDOQLTypedQuery(queryEntityType);
            typedQuery.extension("datanucleus.rdbms.query.multivaluedFetch", (Object)"none");
            if (!range.isUnconstrained()) {
                typedQuery.range(range.getStart(), range.getEnd());
            }
            Can<ManagedObject> resultList = this.fetchWithinTransaction(() -> ((JDOQLTypedQuery)typedQuery).executeList());
            if (range.hasLimit()) {
                _Assert.assertTrue(((long)resultList.size() <= range.getLimit() ? 1 : 0) != 0);
            }
            return resultList;
        }
        if (query instanceof NamedQuery) {
            NamedQuery applibNamedQuery = (NamedQuery)query;
            Class queryResultType = applibNamedQuery.getResultType();
            PersistenceManager persistenceManager = this.getPersistenceManager();
            HashMap namedParams = _Maps.newHashMap();
            javax.jdo.Query namedQuery = persistenceManager.newNamedQuery(queryResultType, applibNamedQuery.getName()).setNamedParameters((Map)namedParams);
            namedQuery.extension("datanucleus.rdbms.query.multivaluedFetch", (Object)"none");
            if (!range.isUnconstrained()) {
                namedQuery.range(range.getStart(), range.getEnd());
            }
            ServiceInjector injector = this.getServiceInjector();
            applibNamedQuery.getParametersByName().values().forEach(arg_0 -> ((ServiceInjector)injector).injectServicesInto(arg_0));
            applibNamedQuery.getParametersByName().forEach(namedParams::put);
            Can<ManagedObject> resultList = this.fetchWithinTransaction(() -> ((javax.jdo.Query)namedQuery).executeList());
            if (range.hasLimit()) {
                _Assert.assertTrue(((long)resultList.size() <= range.getLimit() ? 1 : 0) != 0);
            }
            return resultList;
        }
        throw _Exceptions.unsupportedOperation((String)"query type %s (%s) not supported by this persistence implementation", (Object[])new Object[]{query.getClass(), query.getDescription()});
    }

    public void persist(ObjectSpecification spec, Object pojo) {
        if (pojo == null || !JdoEntityFacet.isPersistableType(pojo.getClass()) || DnEntityStateProvider.entityState(pojo).isAttached()) {
            return;
        }
        PersistenceManager pm = this.getPersistenceManager();
        log.debug("about to persist entity {}", pojo);
        this.getTransactionalProcessor().runWithinCurrentTransactionElseCreateNew(() -> pm.makePersistent(pojo)).optionalElseFail();
    }

    public void delete(ObjectSpecification spec, Object pojo) {
        if (pojo == null || !JdoEntityFacet.isPersistableType(pojo.getClass())) {
            return;
        }
        if (!DnEntityStateProvider.entityState(pojo).isAttached()) {
            throw _Exceptions.illegalArgument((String)"can only delete an attached entity", (Object[])new Object[0]);
        }
        PersistenceManager pm = this.getPersistenceManager();
        log.debug("about to delete entity {}", pojo);
        this.getTransactionalProcessor().runWithinCurrentTransactionElseCreateNew(() -> pm.deletePersistent(pojo)).optionalElseFail();
    }

    public void refresh(Object pojo) {
        if (pojo == null || !JdoEntityFacet.isPersistableType(pojo.getClass()) || !DnEntityStateProvider.entityState(pojo).isPersistable()) {
            return;
        }
        PersistenceManager pm = this.getPersistenceManager();
        log.debug("about to refresh entity {}", pojo);
        this.getTransactionalProcessor().runWithinCurrentTransactionElseCreateNew(() -> pm.refresh(pojo)).optionalElseFail();
    }

    public EntityState getEntityState(Object pojo) {
        return DnEntityStateProvider.entityState(pojo);
    }

    public <T> T detach(T pojo) {
        return (T)this.getPersistenceManager().detachCopy(pojo);
    }

    private static boolean isPersistableType(Class<?> type) {
        return Persistable.class.isAssignableFrom(type);
    }

    public boolean isProxyEnhancement(Method method) {
        return this.jdoFacetContext.isMethodProvidedByEnhancement(method);
    }

    private PersistenceManager getPersistenceManager() {
        if (this.pmf == null) {
            this.getFacetHolder().getServiceInjector().injectServicesInto((Object)this);
        }
        return this.pmf.getPersistenceManagerFactory().getPersistenceManager();
    }

    private TransactionalProcessor getTransactionalProcessor() {
        if (this.txService == null) {
            this.getFacetHolder().getServiceInjector().injectServicesInto((Object)this);
        }
        return this.txService;
    }

    private Can<ManagedObject> fetchWithinTransaction(Supplier<List<?>> fetcher) {
        EntityChangeTracker entityChangeTracker = (EntityChangeTracker)this.getFacetHolder().getServiceRegistry().lookupServiceElseFail(EntityChangeTracker.class);
        return (Can)this.getTransactionalProcessor().callWithinCurrentTransactionElseCreateNew(() -> (Can)_NullSafe.stream((Collection)((Collection)fetcher.get())).map(fetchedObject -> this.adopt(entityChangeTracker, fetchedObject)).collect(Can.toCan())).presentElseFail();
    }

    private ManagedObject adopt(EntityChangeTracker entityChangeTracker, Object fetchedObject) {
        if (fetchedObject instanceof Persistable) {
            ManagedObject entity = this.objectManager.adapt(fetchedObject);
            entityChangeTracker.recognizeLoaded(entity);
            return entity;
        }
        return this.objectManager.adapt(fetchedObject);
    }
}

