/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.mixins;

import java.io.IOException;
import javax.inject.Inject;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.metadata.TypeMetadata;
import javax.xml.bind.JAXBException;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.persistence.jdo.applib.services.JdoSupportService;
import org.datanucleus.enhancement.Persistable;

@Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, commandPublishing=Publishing.DISABLED, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING)
@ActionLayout(cssClassFa="fa-download", position=ActionLayout.Position.PANEL_DROPDOWN, associateWith="metadata", sequence="710.1")
public class Persistable_downloadJdoMetadata {
    @Inject
    JdoSupportService jdoSupport;
    private final Persistable persistable;

    @MemberSupport
    public Clob act(@ParameterLayout(named="File name") String fileName) throws JAXBException, IOException {
        Class<?> objClass = this.persistable.getClass();
        String objClassName = objClass.getName();
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(objClassName);
        String xml = metadata.toString();
        return new Clob(_Strings.asFileNameWithExtension((String)fileName, (String)"jdo"), "text/xml", (CharSequence)xml);
    }

    @MemberSupport
    public String default0Act() {
        return _Strings.asFileNameWithExtension((String)this.persistable.getClass().getName(), (String)"jdo");
    }

    private PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.jdoSupport.getPersistenceManager().getPersistenceManagerFactory();
    }

    public Persistable_downloadJdoMetadata(Persistable persistable) {
        this.persistable = persistable;
    }

    public static class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<Persistable_downloadJdoMetadata> {
    }
}

