/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.oid;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.StringIdentity;
import lombok.NonNull;
import org.apache.isis.applib.services.bookmark.Oid;
import org.apache.isis.commons.handler.ChainOfResponsibility;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.persistence.jdo.datanucleus.oid._JdoObjectIdDecoder;
import org.apache.isis.persistence.jdo.datanucleus.oid._JdoObjectIdEncoder;
import org.datanucleus.identity.DatastoreId;
import org.springframework.lang.Nullable;

public final class JdoObjectIdSerializer {
    static final char SEPARATOR = '_';
    private static final ChainOfResponsibility<Object, String> encodingChain = ChainOfResponsibility.named((String)"JdoObjectIdEncoder", JdoObjectIdSerializer.encoders());
    private static final ChainOfResponsibility<_JdoObjectIdDecoder.JdoObjectIdDecodingRequest, Object> decodingChain = ChainOfResponsibility.named((String)"JdoObjectIdDecoder", JdoObjectIdSerializer.decoders());

    public static String identifierForElseFail(@NonNull PersistenceManager pm, @Nullable Object pojo) {
        if (pm == null) {
            throw new NullPointerException("pm is marked non-null but is null");
        }
        return JdoObjectIdSerializer.identifierFor(pm, pojo).orElseThrow(() -> _Exceptions.illegalArgument((String)"Pojo of type '%s' is not recognized by JDO.", (Object[])new Object[]{pojo.getClass().getName()}));
    }

    public static Optional<String> identifierFor(@NonNull PersistenceManager pm, @Nullable Object pojo) {
        if (pm == null) {
            throw new NullPointerException("pm is marked non-null but is null");
        }
        Object jdoOid = pm.getObjectId(pojo);
        return Optional.ofNullable(jdoOid).map(JdoObjectIdSerializer::toOidIdentifier);
    }

    public static String toOidIdentifier(Object jdoOid) {
        return (String)encodingChain.handle(jdoOid);
    }

    public static Object toJdoObjectId(ObjectSpecification spec, Oid oid) {
        _JdoObjectIdDecoder.JdoObjectIdDecodingRequest request = _JdoObjectIdDecoder.JdoObjectIdDecodingRequest.parse(spec, oid.getIdentifier());
        return decodingChain.handle((Object)request);
    }

    private static List<_JdoObjectIdEncoder> encoders() {
        List<String> nonSafeUrlChars = Arrays.asList("/", "\\");
        List<_JdoObjectIdEncoder> encoders = Arrays.asList(_JdoObjectIdEncoder.of(_JdoObjectIdEncoder.filter(ByteIdentity.class), _JdoObjectIdEncoder.stringifier("b")), _JdoObjectIdEncoder.of(_JdoObjectIdEncoder.filter(IntIdentity.class), _JdoObjectIdEncoder.stringifier("i")), _JdoObjectIdEncoder.of(_JdoObjectIdEncoder.filter(LongIdentity.class), _JdoObjectIdEncoder.stringifier("l")), _JdoObjectIdEncoder.of(_JdoObjectIdEncoder.filter(StringIdentity.class), jdoOid -> {
            String stringified = "" + jdoOid;
            if (nonSafeUrlChars.stream().anyMatch(stringified::contains)) {
                return "base64_" + _Strings.base64UrlEncode((String)stringified);
            }
            return "s_" + stringified;
        }), _JdoObjectIdEncoder.of(jdoOid -> {
            if (jdoOid instanceof ObjectIdentity) {
                ObjectIdentity id = (ObjectIdentity)jdoOid;
                return id.getKeyAsObject() instanceof UUID;
            }
            return false;
        }, jdoOid -> {
            ObjectIdentity id = (ObjectIdentity)jdoOid;
            UUID uuid = (UUID)id.getKeyAsObject();
            return "u_" + uuid.toString();
        }), _JdoObjectIdEncoder.of(jdoOid -> {
            DatastoreId dnOid;
            Object keyValue;
            return jdoOid instanceof DatastoreId && ((keyValue = (dnOid = (DatastoreId)jdoOid).getKeyAsObject()) instanceof String || keyValue instanceof Long || keyValue instanceof BigDecimal || keyValue instanceof BigInteger || keyValue instanceof Integer);
        }, jdoOid -> {
            DatastoreId dnOid = (DatastoreId)jdoOid;
            return "" + dnOid.getKeyAsObject();
        }), _JdoObjectIdEncoder.of(jdoOid -> true, jdoOid -> jdoOid.getClass().getName() + "_" + jdoOid.toString()));
        return encoders;
    }

    private static List<_JdoObjectIdDecoder> decoders() {
        List<String> dnPrefixes = Arrays.asList("S", "I", "L", "M", "B");
        List<_JdoObjectIdDecoder> decoders = Arrays.asList(_JdoObjectIdDecoder.of(_JdoObjectIdDecoder.filter("b"), _JdoObjectIdDecoder.parser(Byte::parseByte, ByteIdentity::new)), _JdoObjectIdDecoder.of(_JdoObjectIdDecoder.filter("i"), _JdoObjectIdDecoder.parser(Integer::parseInt, IntIdentity::new)), _JdoObjectIdDecoder.of(_JdoObjectIdDecoder.filter("l"), _JdoObjectIdDecoder.parser(Long::parseLong, LongIdentity::new)), _JdoObjectIdDecoder.of(_JdoObjectIdDecoder.filter("s"), _JdoObjectIdDecoder.parser(Function.identity(), StringIdentity::new)), _JdoObjectIdDecoder.of(_JdoObjectIdDecoder.filter("base64"), _JdoObjectIdDecoder.parser(_Strings::base64UrlDecode, (type, keyStr) -> new StringIdentity(type, _Strings.base64UrlDecode((String)keyStr)))), _JdoObjectIdDecoder.of(_JdoObjectIdDecoder.filter("u"), _JdoObjectIdDecoder.parser(UUID::fromString, (type, keyStr) -> new ObjectIdentity(type, (Object)UUID.fromString(keyStr)))), _JdoObjectIdDecoder.of(_JdoObjectIdDecoder.filter(""), _JdoObjectIdDecoder.JdoObjectIdDecodingRequest::getKeyStr), _JdoObjectIdDecoder.of(request -> dnPrefixes.contains(request.getDistinguisher()), request -> request.getKeyStr() + "[OID]" + request.getSpec().getFullIdentifier()), _JdoObjectIdDecoder.of(request -> true, request -> {
            String clsName = request.getDistinguisher();
            String keyStr = request.getKeyStr();
            try {
                Class cls = _Context.loadClass((String)clsName);
                Constructor cons = cls.getConstructor(String.class);
                Object dnOid = cons.newInstance(keyStr);
                return dnOid.toString();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw _Exceptions.unrecoverableFormatted((String)"failed to instantiate %s with arg %s", (Object[])new Object[]{clsName, keyStr, e});
            }
        }));
        return decoders;
    }

    private JdoObjectIdSerializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

