/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.oid;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.jdo.annotations.IdentityType;
import lombok.NonNull;
import org.apache.isis.commons.handler.ChainOfResponsibility;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

final class _JdoObjectIdDecoder
implements ChainOfResponsibility.Handler<JdoObjectIdDecodingRequest, Object> {
    @NonNull
    private final Predicate<JdoObjectIdDecodingRequest> filter;
    @NonNull
    private final Function<JdoObjectIdDecodingRequest, Object> parser;

    public boolean isHandling(JdoObjectIdDecodingRequest request) {
        return this.filter.test(request);
    }

    public Object handle(JdoObjectIdDecodingRequest request) {
        return this.parser.apply(request);
    }

    public static Predicate<JdoObjectIdDecodingRequest> filter(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return request -> token.equals(request.getDistinguisher());
    }

    public static Function<JdoObjectIdDecodingRequest, Object> parser(@NonNull Function<String, ? extends Object> appIdFactory, @NonNull BiFunction<Class<?>, String, Object> jdoObjectIdFactory) {
        if (appIdFactory == null) {
            throw new NullPointerException("appIdFactory is marked non-null but is null");
        }
        if (jdoObjectIdFactory == null) {
            throw new NullPointerException("jdoObjectIdFactory is marked non-null but is null");
        }
        return request -> request.isApplicationIdentity() ? appIdFactory.apply(request.getKeyStr()) : jdoObjectIdFactory.apply(request.getSpec().getCorrespondingClass(), request.getKeyStr());
    }

    private _JdoObjectIdDecoder(@NonNull Predicate<JdoObjectIdDecodingRequest> filter, @NonNull Function<JdoObjectIdDecodingRequest, Object> parser) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        this.filter = filter;
        this.parser = parser;
    }

    public static _JdoObjectIdDecoder of(@NonNull Predicate<JdoObjectIdDecodingRequest> filter, @NonNull Function<JdoObjectIdDecodingRequest, Object> parser) {
        return new _JdoObjectIdDecoder(filter, parser);
    }

    @NonNull
    public Predicate<JdoObjectIdDecodingRequest> getFilter() {
        return this.filter;
    }

    @NonNull
    public Function<JdoObjectIdDecodingRequest, Object> getParser() {
        return this.parser;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof _JdoObjectIdDecoder)) {
            return false;
        }
        _JdoObjectIdDecoder other = (_JdoObjectIdDecoder)o;
        Predicate<JdoObjectIdDecodingRequest> this$filter = this.getFilter();
        Predicate<JdoObjectIdDecodingRequest> other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Function<JdoObjectIdDecodingRequest, Object> this$parser = this.getParser();
        Function<JdoObjectIdDecodingRequest, Object> other$parser = other.getParser();
        return !(this$parser == null ? other$parser != null : !this$parser.equals(other$parser));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Predicate<JdoObjectIdDecodingRequest> $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Function<JdoObjectIdDecodingRequest, Object> $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        return result;
    }

    public String toString() {
        return "_JdoObjectIdDecoder(filter=" + this.getFilter() + ", parser=" + this.getParser() + ")";
    }

    static final class JdoObjectIdDecodingRequest {
        private final ObjectSpecification spec;
        private final String distinguisher;
        private final String keyStr;

        boolean isApplicationIdentity() {
            JdoPersistenceCapableFacet jdoPersistenceCapableFacet = (JdoPersistenceCapableFacet)this.spec.getFacet(JdoPersistenceCapableFacet.class);
            return jdoPersistenceCapableFacet != null && jdoPersistenceCapableFacet.getIdentityType() == IdentityType.APPLICATION;
        }

        public static JdoObjectIdDecodingRequest parse(ObjectSpecification spec, String idStr) {
            int separatorIdx = (idStr = _Strings.nullToEmpty((String)idStr)).indexOf(95);
            return separatorIdx != -1 ? JdoObjectIdDecodingRequest.of(spec, idStr.substring(0, separatorIdx), idStr.substring(separatorIdx + 1)) : JdoObjectIdDecodingRequest.of(spec, "", idStr);
        }

        private JdoObjectIdDecodingRequest(ObjectSpecification spec, String distinguisher, String keyStr) {
            this.spec = spec;
            this.distinguisher = distinguisher;
            this.keyStr = keyStr;
        }

        public static JdoObjectIdDecodingRequest of(ObjectSpecification spec, String distinguisher, String keyStr) {
            return new JdoObjectIdDecodingRequest(spec, distinguisher, keyStr);
        }

        public ObjectSpecification getSpec() {
            return this.spec;
        }

        public String getDistinguisher() {
            return this.distinguisher;
        }

        public String getKeyStr() {
            return this.keyStr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JdoObjectIdDecodingRequest)) {
                return false;
            }
            JdoObjectIdDecodingRequest other = (JdoObjectIdDecodingRequest)o;
            ObjectSpecification this$spec = this.getSpec();
            ObjectSpecification other$spec = other.getSpec();
            if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
                return false;
            }
            String this$distinguisher = this.getDistinguisher();
            String other$distinguisher = other.getDistinguisher();
            if (this$distinguisher == null ? other$distinguisher != null : !this$distinguisher.equals(other$distinguisher)) {
                return false;
            }
            String this$keyStr = this.getKeyStr();
            String other$keyStr = other.getKeyStr();
            return !(this$keyStr == null ? other$keyStr != null : !this$keyStr.equals(other$keyStr));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ObjectSpecification $spec = this.getSpec();
            result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
            String $distinguisher = this.getDistinguisher();
            result = result * 59 + ($distinguisher == null ? 43 : $distinguisher.hashCode());
            String $keyStr = this.getKeyStr();
            result = result * 59 + ($keyStr == null ? 43 : $keyStr.hashCode());
            return result;
        }

        public String toString() {
            return "_JdoObjectIdDecoder.JdoObjectIdDecodingRequest(spec=" + this.getSpec() + ", distinguisher=" + this.getDistinguisher() + ", keyStr=" + this.getKeyStr() + ")";
        }
    }
}

