/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.oid;

import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.isis.commons.handler.ChainOfResponsibility;

final class _JdoObjectIdEncoder
implements ChainOfResponsibility.Handler<Object, String> {
    @NonNull
    private final Predicate<Object> filter;
    @NonNull
    private final Function<Object, String> keyStringifier;

    public boolean isHandling(Object jdoOid) {
        return this.filter.test(jdoOid);
    }

    public String handle(Object jdoOid) {
        return this.keyStringifier.apply(jdoOid);
    }

    public static Predicate<Object> filter(Class<?> jdoKeyType) {
        return jdoOid -> jdoKeyType.isAssignableFrom(jdoOid.getClass());
    }

    public static Function<Object, String> stringifier(String token) {
        return jdoOid -> token + "_" + jdoOid;
    }

    private _JdoObjectIdEncoder(@NonNull Predicate<Object> filter, @NonNull Function<Object, String> keyStringifier) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (keyStringifier == null) {
            throw new NullPointerException("keyStringifier is marked non-null but is null");
        }
        this.filter = filter;
        this.keyStringifier = keyStringifier;
    }

    public static _JdoObjectIdEncoder of(@NonNull Predicate<Object> filter, @NonNull Function<Object, String> keyStringifier) {
        return new _JdoObjectIdEncoder(filter, keyStringifier);
    }

    @NonNull
    public Predicate<Object> getFilter() {
        return this.filter;
    }

    @NonNull
    public Function<Object, String> getKeyStringifier() {
        return this.keyStringifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof _JdoObjectIdEncoder)) {
            return false;
        }
        _JdoObjectIdEncoder other = (_JdoObjectIdEncoder)o;
        Predicate<Object> this$filter = this.getFilter();
        Predicate<Object> other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Function<Object, String> this$keyStringifier = this.getKeyStringifier();
        Function<Object, String> other$keyStringifier = other.getKeyStringifier();
        return !(this$keyStringifier == null ? other$keyStringifier != null : !this$keyStringifier.equals(other$keyStringifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Predicate<Object> $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Function<Object, String> $keyStringifier = this.getKeyStringifier();
        result = result * 59 + ($keyStringifier == null ? 43 : $keyStringifier.hashCode());
        return result;
    }

    public String toString() {
        return "_JdoObjectIdEncoder(filter=" + this.getFilter() + ", keyStringifier=" + this.getKeyStringifier() + ")";
    }
}

