/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.typeconverters.time;

import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import org.datanucleus.store.types.converters.TypeConverter;

public class IsoOffsetTimeConverter
implements TypeConverter<OffsetTime, String> {
    private static final long serialVersionUID = 1L;

    public String toDatastoreType(OffsetTime offsetTime) {
        return offsetTime != null ? offsetTime.format(DateTimeFormatter.ISO_OFFSET_TIME) : null;
    }

    public OffsetTime toMemberType(String datastoreValue) {
        return datastoreValue != null ? OffsetTime.parse(datastoreValue, DateTimeFormatter.ISO_OFFSET_TIME) : null;
    }
}

