/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.typeconverters.time;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.datanucleus.store.types.converters.TypeConverter;

public class IsoZonedDateTimeConverter
implements TypeConverter<ZonedDateTime, String> {
    private static final long serialVersionUID = 1L;

    public String toDatastoreType(ZonedDateTime offsetTime) {
        return offsetTime != null ? offsetTime.format(DateTimeFormatter.ISO_ZONED_DATE_TIME) : null;
    }

    public ZonedDateTime toMemberType(String datastoreValue) {
        return datastoreValue != null ? ZonedDateTime.parse(datastoreValue, DateTimeFormatter.ISO_ZONED_DATE_TIME) : null;
    }
}

