/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.datanucleus.valuetypes.applib;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.isis.applib.value.Blob;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class IsisBlobMapping
extends SingleFieldMultiMapping {
    public Class<?> getJavaType() {
        return Blob.class;
    }

    public void initialize(AbstractMemberMetaData mmd, Table container, ClassLoaderResolver clr) {
        super.initialize(mmd, container, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.JAVA_LANG_STRING);
        this.addColumns(ClassNameConstants.JAVA_LANG_STRING);
        this.addColumns(ClassNameConstants.BYTE_ARRAY);
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        Blob blob = (Blob)value;
        switch (index) {
            case 0: {
                return blob.getName();
            }
            case 1: {
                return blob.getMimeType().getBaseType();
            }
            case 2: {
                return blob.getBytes();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement preparedStmt, int[] exprIndex, Object value) {
        Blob blob = (Blob)value;
        if (blob == null) {
            this.getColumnMapping(0).setString(preparedStmt, exprIndex[0], null);
            this.getColumnMapping(1).setString(preparedStmt, exprIndex[1], null);
            try {
                preparedStmt.setBytes(exprIndex[2], null);
            }
            catch (SQLException sQLException) {}
        } else {
            this.getColumnMapping(0).setString(preparedStmt, exprIndex[0], blob.getName());
            this.getColumnMapping(1).setString(preparedStmt, exprIndex[1], blob.getMimeType().getBaseType());
            this.getColumnMapping(2).setObject(preparedStmt, exprIndex[2], (Object)blob.getBytes());
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        try {
            if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String name = this.getColumnMapping(0).getString(resultSet, exprIndex[0]);
        String mimeTypeBase = this.getColumnMapping(1).getString(resultSet, exprIndex[1]);
        byte[] bytes = (byte[])this.getColumnMapping(2).getObject(resultSet, exprIndex[2]);
        if (name == null || mimeTypeBase == null || bytes == null) {
            return null;
        }
        return new Blob(name, mimeTypeBase, bytes);
    }
}

