/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.integration.changetracking;

import java.sql.Timestamp;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import lombok.NonNull;
import org.apache.isis.applib.annotation.EntityChangeKind;
import org.apache.isis.applib.annotation.InteractionScope;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionProvider;
import org.apache.isis.applib.services.metrics.MetricsService;
import org.apache.isis.applib.services.publishing.spi.EntityChanges;
import org.apache.isis.applib.services.publishing.spi.EntityPropertyChange;
import org.apache.isis.applib.services.xactn.TransactionId;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.publish.entitychange.EntityChangePublishingFacet;
import org.apache.isis.core.metamodel.facets.properties.property.entitychangepublishing.EntityPropertyChangePublishingPolicyFacet;
import org.apache.isis.core.metamodel.services.objectlifecycle.HasEnlistedEntityPropertyChanges;
import org.apache.isis.core.metamodel.services.objectlifecycle.PropertyChangeRecord;
import org.apache.isis.core.metamodel.services.objectlifecycle.PropertyValuePlaceholder;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.transaction.changetracking.EntityChangeTracker;
import org.apache.isis.core.transaction.changetracking.EntityChangesPublisher;
import org.apache.isis.core.transaction.changetracking.EntityPropertyChangePublisher;
import org.apache.isis.core.transaction.changetracking.HasEnlistedEntityChanges;
import org.apache.isis.core.transaction.changetracking.PersistenceCallbackHandlerAbstract;
import org.apache.isis.core.transaction.events.TransactionBeforeCompletionEvent;
import org.apache.isis.persistence.jdo.integration.changetracking._ChangingEntitiesFactory;
import org.apache.isis.persistence.jdo.integration.changetracking._EntityPropertyChangeFactory;
import org.apache.isis.persistence.jdo.integration.changetracking._Xray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.transaction.EntityChangeTrackerJdo")
@Priority(value=0x1FFFFFFF)
@Qualifier(value="jdo")
@InteractionScope
public class EntityChangeTrackerJdo
extends PersistenceCallbackHandlerAbstract
implements MetricsService,
EntityChangeTracker,
HasEnlistedEntityPropertyChanges,
HasEnlistedEntityChanges {
    private static final Logger log = LogManager.getLogger(EntityChangeTrackerJdo.class);
    private final Map<String, PropertyChangeRecord> propertyChangeRecordsById = _Maps.newLinkedHashMap();
    private final _Lazy<Set<PropertyChangeRecord>> entityPropertyChangeRecordsForPublishing = _Lazy.threadSafe(this::capturePostValuesAndDrain);
    private final Map<Bookmark, EntityChangeKind> changeKindByEnlistedAdapter = _Maps.newLinkedHashMap();
    private final EntityPropertyChangePublisher entityPropertyChangePublisher;
    private final EntityChangesPublisher entityChangesPublisher;
    private final Provider<InteractionProvider> interactionProviderProvider;
    private final LongAdder numberEntitiesLoaded = new LongAdder();
    private final LongAdder entityChangeEventCount = new LongAdder();
    private final AtomicBoolean persitentChangesEncountered = new AtomicBoolean();

    @Inject
    public EntityChangeTrackerJdo(EntityPropertyChangePublisher entityPropertyChangePublisher, EntityChangesPublisher entityChangesPublisher, EventBusService eventBusService, Provider<InteractionProvider> interactionProviderProvider) {
        super(eventBusService);
        this.entityPropertyChangePublisher = entityPropertyChangePublisher;
        this.entityChangesPublisher = entityChangesPublisher;
        this.interactionProviderProvider = interactionProviderProvider;
    }

    private boolean isEnlisted(@NonNull ManagedObject adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter is marked non-null but is null");
        }
        return ManagedObjects.bookmark((ManagedObject)adapter).map(this.changeKindByEnlistedAdapter::containsKey).orElse(false);
    }

    private void enlistCreatedInternal(@NonNull ManagedObject adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter is marked non-null but is null");
        }
        if (!this.isEntityEnabledForChangePublishing(adapter)) {
            return;
        }
        this.enlistForChangeKindPublishing(adapter, EntityChangeKind.CREATE);
        this.enlistForPreAndPostValuePublishing(adapter, record -> record.setPreValue((Object)PropertyValuePlaceholder.NEW));
    }

    private void enlistUpdatingInternal(@NonNull ManagedObject entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (!this.isEntityEnabledForChangePublishing(entity)) {
            return;
        }
        this.enlistForChangeKindPublishing(entity, EntityChangeKind.UPDATE);
        this.enlistForPreAndPostValuePublishing(entity, PropertyChangeRecord::updatePreValue);
    }

    private void enlistDeletingInternal(@NonNull ManagedObject adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter is marked non-null but is null");
        }
        if (!this.isEntityEnabledForChangePublishing(adapter)) {
            return;
        }
        boolean enlisted = this.enlistForChangeKindPublishing(adapter, EntityChangeKind.DELETE);
        if (enlisted) {
            this.enlistForPreAndPostValuePublishing(adapter, PropertyChangeRecord::updatePreValue);
        }
    }

    Set<PropertyChangeRecord> snapshotPropertyChangeRecords() {
        return (Set)this.entityPropertyChangeRecordsForPublishing.get();
    }

    private boolean isEntityEnabledForChangePublishing(@NonNull ManagedObject adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter is marked non-null but is null");
        }
        if (this.entityPropertyChangeRecordsForPublishing.isMemoized()) {
            throw _Exceptions.illegalState((String)"Cannot enlist additional changes for auditing, since changedObjectPropertiesRef was already prepared (memoized) for auditing.", (Object[])new Object[0]);
        }
        this.entityChangeEventCount.increment();
        this.enableCommandPublishing();
        return EntityChangePublishingFacet.isPublishingEnabled((FacetHolder)adapter.getSpecification());
    }

    @EventListener(value={TransactionBeforeCompletionEvent.class})
    @Order(value=0x5FFFFFFF)
    public void onTransactionCompleting(TransactionBeforeCompletionEvent event) {
        try {
            this.doPublish();
        }
        finally {
            this.postPublishing();
        }
    }

    private void doPublish() {
        _Xray.publish(this, this.interactionProviderProvider);
        log.debug("about to publish entity changes");
        this.entityPropertyChangePublisher.publishChangedProperties((HasEnlistedEntityPropertyChanges)this);
        this.entityChangesPublisher.publishChangingEntities((HasEnlistedEntityChanges)this);
    }

    private void postPublishing() {
        log.debug("purging entity change records");
        this.propertyChangeRecordsById.clear();
        this.changeKindByEnlistedAdapter.clear();
        this.entityPropertyChangeRecordsForPublishing.clear();
        this.entityChangeEventCount.reset();
        this.numberEntitiesLoaded.reset();
    }

    private void enableCommandPublishing() {
        boolean alreadySet = this.persitentChangesEncountered.getAndSet(true);
        if (!alreadySet) {
            Command command = this.currentInteraction().getCommand();
            command.updater().setSystemStateChanged(true);
        }
    }

    public Optional<EntityChanges> getEntityChanges(Timestamp timestamp, String userName) {
        return _ChangingEntitiesFactory.createChangingEntities(timestamp, userName, this);
    }

    public Can<EntityPropertyChange> getPropertyChanges(Timestamp timestamp, String userName, TransactionId txId) {
        return (Can)this.snapshotPropertyChangeRecords().stream().map(propertyChangeRecord -> _EntityPropertyChangeFactory.createEntityPropertyChange(timestamp, userName, txId, propertyChangeRecord)).collect(Can.toCan());
    }

    Interaction currentInteraction() {
        return ((InteractionProvider)this.interactionProviderProvider.get()).currentInteractionElseFail();
    }

    private boolean enlistForChangeKindPublishing(@NonNull ManagedObject entity, @NonNull EntityChangeKind changeKind) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (changeKind == null) {
            throw new NullPointerException("changeKind is marked non-null but is null");
        }
        Bookmark bookmark = ManagedObjects.bookmarkElseFail((ManagedObject)entity);
        EntityChangeKind previousChangeKind = this.changeKindByEnlistedAdapter.get(bookmark);
        if (previousChangeKind == null) {
            this.changeKindByEnlistedAdapter.put(bookmark, changeKind);
            return true;
        }
        switch (previousChangeKind) {
            case CREATE: {
                switch (changeKind) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.remove(bookmark);
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case UPDATE: {
                switch (changeKind) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.put(bookmark, changeKind);
                        return true;
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case DELETE: {
                return false;
            }
        }
        return previousChangeKind == null;
    }

    private void enlistForPreAndPostValuePublishing(ManagedObject entity, Consumer<PropertyChangeRecord> onNewChangeRecord) {
        log.debug("enlist entity's property changes for publishing {}", (Object)entity);
        entity.getSpecification().streamProperties(MixedIn.EXCLUDED).filter(property -> !EntityPropertyChangePublishingPolicyFacet.isExcludedFromPublishing((OneToOneAssociation)property)).map(property -> PropertyChangeRecord.of((ManagedObject)entity, (ObjectAssociation)property)).filter(record -> !this.propertyChangeRecordsById.containsKey(record.getPropertyId())).forEach(record -> {
            onNewChangeRecord.accept((PropertyChangeRecord)record);
            this.propertyChangeRecordsById.put(record.getPropertyId(), (PropertyChangeRecord)record);
        });
    }

    private Set<PropertyChangeRecord> capturePostValuesAndDrain() {
        Set records = (Set)this.propertyChangeRecordsById.values().stream().peek(rec -> {
            if (ManagedObjects.EntityUtil.isDetachedOrRemoved((ManagedObject)rec.getEntity())) {
                rec.updatePostValueAsDeleted();
            } else {
                rec.updatePostValueAsNonDeleted();
            }
        }).filter(managedProperty -> managedProperty.getPreAndPostValue().shouldPublish()).collect(_Sets.toUnmodifiable());
        this.propertyChangeRecordsById.clear();
        return records;
    }

    long countPotentialPropertyChangeRecords() {
        return this.propertyChangeRecordsById.size();
    }

    public int numberEntitiesLoaded() {
        return Math.toIntExact(this.numberEntitiesLoaded.longValue());
    }

    public int numberEntitiesDirtied() {
        return this.changeKindByEnlistedAdapter.size();
    }

    public void enlistCreated(ManagedObject entity) {
        _Xray.enlistCreated(entity, this.interactionProviderProvider);
        boolean hasAlreadyBeenEnlisted = this.isEnlisted(entity);
        this.enlistCreatedInternal(entity);
        if (!hasAlreadyBeenEnlisted) {
            CallbackFacet.callCallback((ManagedObject)entity, PersistedCallbackFacet.class);
            this.postLifecycleEventIfRequired(entity, PersistedLifecycleEventFacet.class);
        }
    }

    public void enlistDeleting(ManagedObject entity) {
        _Xray.enlistDeleting(entity, this.interactionProviderProvider);
        this.enlistDeletingInternal(entity);
        CallbackFacet.callCallback((ManagedObject)entity, RemovingCallbackFacet.class);
        this.postLifecycleEventIfRequired(entity, RemovingLifecycleEventFacet.class);
    }

    public void enlistUpdating(ManagedObject entity) {
        _Xray.enlistUpdating(entity, this.interactionProviderProvider);
        boolean hasAlreadyBeenEnlisted = this.isEnlisted(entity);
        this.enlistUpdatingInternal(entity);
        if (!hasAlreadyBeenEnlisted) {
            CallbackFacet.callCallback((ManagedObject)entity, UpdatingCallbackFacet.class);
            this.postLifecycleEventIfRequired(entity, UpdatingLifecycleEventFacet.class);
        }
    }

    public void recognizeLoaded(ManagedObject entity) {
        _Xray.recognizeLoaded(entity, this.interactionProviderProvider);
        CallbackFacet.callCallback((ManagedObject)entity, LoadedCallbackFacet.class);
        this.postLifecycleEventIfRequired(entity, LoadedLifecycleEventFacet.class);
        this.numberEntitiesLoaded.increment();
    }

    public void recognizePersisting(ManagedObject entity) {
        _Xray.recognizePersisting(entity, this.interactionProviderProvider);
        CallbackFacet.callCallback((ManagedObject)entity, PersistingCallbackFacet.class);
        this.postLifecycleEventIfRequired(entity, PersistingLifecycleEventFacet.class);
    }

    public void recognizeUpdating(ManagedObject entity) {
        _Xray.recognizeUpdating(entity, this.interactionProviderProvider);
        CallbackFacet.callCallback((ManagedObject)entity, UpdatedCallbackFacet.class);
        this.postLifecycleEventIfRequired(entity, UpdatedLifecycleEventFacet.class);
    }

    Map<Bookmark, EntityChangeKind> getChangeKindByEnlistedAdapter() {
        return this.changeKindByEnlistedAdapter;
    }
}

