/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.integration.changetracking;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.isis.applib.annotation.EntityChangeKind;
import org.apache.isis.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.publishing.spi.EntityChanges;
import org.apache.isis.core.metamodel.execution.InteractionInternal;
import org.apache.isis.persistence.jdo.integration.changetracking.EntityChangeTrackerJdo;
import org.apache.isis.persistence.jdo.integration.changetracking._SimpleChangingEntities;
import org.apache.isis.schema.chg.v2.ChangesDto;
import org.apache.isis.schema.chg.v2.ObjectsDto;
import org.apache.isis.schema.common.v2.OidDto;
import org.apache.isis.schema.common.v2.OidsDto;

final class _ChangingEntitiesFactory {
    _ChangingEntitiesFactory() {
    }

    public static Optional<EntityChanges> createChangingEntities(Timestamp completedAt, String userName, EntityChangeTrackerJdo entityChangeTracker) {
        if (entityChangeTracker.getChangeKindByEnlistedAdapter().isEmpty()) {
            return Optional.empty();
        }
        HashMap<Bookmark, EntityChangeKind> changeKindByEnlistedAdapter = new HashMap<Bookmark, EntityChangeKind>(entityChangeTracker.getChangeKindByEnlistedAdapter());
        EntityChanges changingEntities = _ChangingEntitiesFactory.newChangingEntities(completedAt, userName, entityChangeTracker.currentInteraction(), entityChangeTracker.numberEntitiesLoaded(), entityChangeTracker.snapshotPropertyChangeRecords().size(), changeKindByEnlistedAdapter);
        return Optional.of(changingEntities);
    }

    private static EntityChanges newChangingEntities(Timestamp completedAt, String userName, Interaction interaction, int numberEntitiesLoaded, int numberEntityPropertiesModified, Map<Bookmark, EntityChangeKind> changeKindByEnlistedAdapter) {
        UUID interactionId = interaction.getInteractionId();
        int nextEventSequence = ((InteractionInternal)interaction).getThenIncrementTransactionSequence();
        return new _SimpleChangingEntities(interactionId, nextEventSequence, userName, completedAt, numberEntitiesLoaded, numberEntityPropertiesModified, () -> _ChangingEntitiesFactory.newDto(interactionId, nextEventSequence, userName, completedAt, numberEntitiesLoaded, numberEntityPropertiesModified, changeKindByEnlistedAdapter));
    }

    private static ChangesDto newDto(UUID interactionId, int transactionSequenceNum, String userName, Timestamp completedAt, int numberEntitiesLoaded, int numberEntityPropertiesModified, Map<Bookmark, EntityChangeKind> changeKindByEnlistedEntity) {
        ObjectsDto objectsDto = new ObjectsDto();
        objectsDto.setCreated(new OidsDto());
        objectsDto.setUpdated(new OidsDto());
        objectsDto.setDeleted(new OidsDto());
        changeKindByEnlistedEntity.forEach((bookmark, kind) -> {
            OidDto oidDto = bookmark.toOidDto();
            if (oidDto == null) {
                return;
            }
            switch (kind) {
                case CREATE: {
                    objectsDto.getCreated().getOid().add(oidDto);
                    return;
                }
                case UPDATE: {
                    objectsDto.getUpdated().getOid().add(oidDto);
                    return;
                }
                case DELETE: {
                    objectsDto.getDeleted().getOid().add(oidDto);
                    return;
                }
            }
        });
        objectsDto.setLoaded(numberEntitiesLoaded);
        objectsDto.setPropertiesModified(numberEntityPropertiesModified);
        ChangesDto changesDto = new ChangesDto();
        changesDto.setMajorVersion("2");
        changesDto.setMinorVersion("0");
        changesDto.setInteractionId(interactionId.toString());
        changesDto.setSequence(transactionSequenceNum);
        changesDto.setUser(userName);
        changesDto.setCompletedAt(JavaSqlXMLGregorianCalendarMarshalling.toXMLGregorianCalendar((Timestamp)completedAt));
        changesDto.setObjects(objectsDto);
        return changesDto;
    }
}

