/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.beans;

import java.util.Locale;
import java.util.Optional;
import javax.jdo.annotations.EmbeddedOnly;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.services.metamodel.BeanSort;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.reflection._Annotations;
import org.apache.isis.core.config.beans.IsisBeanTypeClassifier;

public class JdoBeanTypeClassifier
implements IsisBeanTypeClassifier {
    public IsisBeanTypeClassifier.BeanClassification classify(Class<?> type) {
        Optional persistenceCapableAnnot = _Annotations.synthesize(type, PersistenceCapable.class);
        if (persistenceCapableAnnot.isPresent()) {
            String schema;
            boolean embeddedOnly;
            String embeddedOnlyAttribute = ((PersistenceCapable)persistenceCapableAnnot.get()).embeddedOnly();
            boolean bl = embeddedOnly = Boolean.valueOf(embeddedOnlyAttribute) != false || _Annotations.synthesize(type, EmbeddedOnly.class).isPresent();
            if (embeddedOnly) {
                return null;
            }
            String logicalTypeName = null;
            DomainObject aDomainObject = _Annotations.synthesize(type, DomainObject.class).orElse(null);
            if (aDomainObject != null) {
                logicalTypeName = aDomainObject.logicalTypeName();
            }
            if (_Strings.isEmpty(logicalTypeName) && _Strings.isNotEmpty((CharSequence)(schema = ((PersistenceCapable)persistenceCapableAnnot.get()).schema()))) {
                String table = ((PersistenceCapable)persistenceCapableAnnot.get()).table();
                logicalTypeName = String.format("%s.%s", schema.toLowerCase(Locale.ROOT), _Strings.isNotEmpty((CharSequence)table) ? table : type.getSimpleName());
            }
            if (_Strings.isNotEmpty((CharSequence)logicalTypeName)) {
                IsisBeanTypeClassifier.BeanClassification.selfManaged((BeanSort)BeanSort.ENTITY, (String)logicalTypeName);
            }
            return IsisBeanTypeClassifier.BeanClassification.selfManaged((BeanSort)BeanSort.ENTITY);
        }
        return null;
    }
}

