/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.datastoreidentity;

import java.util.Optional;
import javax.inject.Inject;
import javax.jdo.annotations.DatastoreIdentity;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.persistence.jdo.metamodel.facets.object.datastoreidentity.JdoDatastoreIdentityFacetAnnotation;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoDatastoreIdentityAnnotationFacetFactory
extends FacetFactoryAbstract {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public JdoDatastoreIdentityAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.OBJECTS_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        Optional datastoreIdentityIfAny = processClassContext.synthesizeOnType(DatastoreIdentity.class);
        FacetUtil.addFacetIfPresent(JdoDatastoreIdentityFacetAnnotation.create(datastoreIdentityIfAny, processClassContext.getFacetHolder()));
    }
}

