/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.discriminator;

import javax.inject.Inject;
import javax.jdo.annotations.Discriminator;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.ObjectTypeFacetFactory;
import org.apache.isis.core.metamodel.facets.object.logicaltype.classname.LogicalTypeFacetFromClassName;
import org.apache.isis.core.metamodel.services.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.services.classsubstitutor.ClassSubstitutorRegistry;
import org.apache.isis.persistence.jdo.metamodel.facets.object.discriminator.JdoDiscriminatorFacetDefault;
import org.apache.isis.persistence.jdo.metamodel.facets.object.discriminator.LogicalTypeFacetFromJdoDiscriminatorValueAnnotation;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoDiscriminatorAnnotationFacetFactory
extends FacetFactoryAbstract
implements ObjectTypeFacetFactory {
    private final ClassSubstitutorRegistry classSubstitutorRegistry;
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public JdoDiscriminatorAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext, ClassSubstitutorRegistry classSubstitutorRegistry) {
        super(mmc, FeatureType.OBJECTS_ONLY);
        this.jdoFacetContext = jdoFacetContext;
        this.classSubstitutorRegistry = classSubstitutorRegistry;
    }

    public void process(ObjectTypeFacetFactory.ProcessObjectTypeContext processClassContext) {
        LogicalTypeFacetFromJdoDiscriminatorValueAnnotation logicalTypeFacet;
        Class cls = processClassContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        Discriminator annotation = processClassContext.synthesizeOnType(Discriminator.class).orElse(null);
        if (annotation == null) {
            return;
        }
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        String annotationValue = annotation.value();
        if (!_Strings.isNullOrEmpty((CharSequence)annotationValue)) {
            logicalTypeFacet = new LogicalTypeFacetFromJdoDiscriminatorValueAnnotation(LogicalType.eager((Class)cls, (String)annotationValue), facetHolder);
        } else {
            ClassSubstitutor.Substitution substitute = this.classSubstitutorRegistry.getSubstitution(cls);
            if (substitute.isNeverIntrospect()) {
                return;
            }
            Class substituted = substitute.apply(cls);
            logicalTypeFacet = new LogicalTypeFacetFromClassName(LogicalType.eager((Class)substituted, (String)substituted.getCanonicalName()), facetHolder);
        }
        FacetUtil.addFacet((Facet)logicalTypeFacet);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        Discriminator annotation = processClassContext.synthesizeOnType(Discriminator.class).orElse(null);
        if (annotation == null) {
            return;
        }
        String annotationValueAttribute = annotation.value();
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new JdoDiscriminatorFacetDefault(annotationValueAttribute, facetHolder));
    }
}

