/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.domainobject.objectspecid;

import java.util.Locale;
import java.util.Optional;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.logicaltype.LogicalTypeFacet;
import org.apache.isis.core.metamodel.facets.object.logicaltype.LogicalTypeFacetAbstract;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

public class LogicalTypeFacetFromJdoPersistenceCapableAnnotation
extends LogicalTypeFacetAbstract {
    public static Optional<LogicalTypeFacet> create(JdoPersistenceCapableFacet persistenceCapableFacet, Class<?> correspondingClass, FacetHolder holder) {
        if (persistenceCapableFacet.getPrecedence().isFallback()) {
            return Optional.empty();
        }
        String schema = persistenceCapableFacet.getSchema();
        if (_Strings.isNullOrEmpty((CharSequence)schema)) {
            return Optional.empty();
        }
        String logicalTypeName = schema.toLowerCase(Locale.ROOT) + "." + persistenceCapableFacet.getTable();
        return Optional.of(new LogicalTypeFacetFromJdoPersistenceCapableAnnotation(LogicalType.eager(correspondingClass, (String)logicalTypeName), holder));
    }

    private LogicalTypeFacetFromJdoPersistenceCapableAnnotation(LogicalType logicalType, FacetHolder holder) {
        super(logicalType, holder, Facet.Precedence.INFERRED);
    }
}

