/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.persistencecapable;

import java.util.Optional;
import javax.inject.Inject;
import javax.jdo.annotations.EmbeddedOnly;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.ObjectTypeFacetFactory;
import org.apache.isis.persistence.jdo.metamodel.facets.object.domainobject.objectspecid.LogicalTypeFacetFromJdoPersistenceCapableAnnotation;
import org.apache.isis.persistence.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacetFromAnnotation;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoPersistenceCapableFacetFactory
extends FacetFactoryAbstract
implements ObjectTypeFacetFactory {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public JdoPersistenceCapableFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.OBJECTS_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(ObjectTypeFacetFactory.ProcessObjectTypeContext processClassContext) {
        Class cls = processClassContext.getCls();
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        Optional persistenceCapableIfAny = processClassContext.synthesizeOnType(PersistenceCapable.class);
        if (!persistenceCapableIfAny.isPresent()) {
            return;
        }
        Optional embeddedOnlyIfAny = processClassContext.synthesizeOnType(EmbeddedOnly.class);
        FacetUtil.addFacetIfPresent(JdoPersistenceCapableFacetFromAnnotation.create(persistenceCapableIfAny, embeddedOnlyIfAny, cls, facetHolder)).ifPresent(jdoPersistenceCapableFacet -> {
            FacetUtil.addFacetIfPresent(LogicalTypeFacetFromJdoPersistenceCapableAnnotation.create(jdoPersistenceCapableFacet, cls, facetHolder));
            FacetUtil.addFacet((Facet)this.jdoFacetContext.createEntityFacet(facetHolder));
        });
    }
}

