/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.persistencecapable;

import java.util.Optional;
import java.util.function.BiConsumer;
import javax.jdo.annotations.EmbeddedOnly;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

public class JdoPersistenceCapableFacetFromAnnotation
extends FacetAbstract
implements JdoPersistenceCapableFacet {
    private final String schema;
    private final String table;
    private final IdentityType identityType;

    public static Optional<JdoPersistenceCapableFacet> create(Optional<PersistenceCapable> persistenceCapableIfAny, Optional<EmbeddedOnly> embeddedOnlyIfAny, Class<?> cls, FacetHolder facetHolder) {
        boolean isEmbeddedOnly;
        if (!persistenceCapableIfAny.isPresent()) {
            return Optional.empty();
        }
        PersistenceCapable persistenceCapable = persistenceCapableIfAny.get();
        boolean bl = isEmbeddedOnly = Boolean.valueOf(persistenceCapable.embeddedOnly()) != false || embeddedOnlyIfAny.isPresent();
        if (isEmbeddedOnly) {
            return Optional.empty();
        }
        String schema = _Strings.emptyToNull((String)persistenceCapable.schema());
        String table = _Strings.isNotEmpty((CharSequence)persistenceCapable.table()) ? persistenceCapable.table() : cls.getSimpleName();
        IdentityType identityType = persistenceCapable.identityType();
        return Optional.of(new JdoPersistenceCapableFacetFromAnnotation(schema, table, identityType, facetHolder));
    }

    private JdoPersistenceCapableFacetFromAnnotation(String schemaName, String tableOrTypeName, IdentityType identityType, FacetHolder holder) {
        super(JdoPersistenceCapableFacet.class, holder);
        this.schema = schemaName;
        this.table = tableOrTypeName;
        this.identityType = identityType;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public void visitAttributes(BiConsumer<String, Object> visitor) {
        super.visitAttributes(visitor);
        visitor.accept("schema", this.schema);
        visitor.accept("table", this.table);
        visitor.accept("identityType", this.identityType);
    }
}

