/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.query;

import java.util.function.BiConsumer;
import javax.jdo.annotations.Query;
import lombok.NonNull;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.query.JdoNamedQuery;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.query.JdoQueryFacet;

public class JdoQueryFacetAbstract
extends FacetAbstract
implements JdoQueryFacet {
    private final Can<JdoNamedQuery> namedQueries;

    private static final Class<? extends Facet> type() {
        return JdoQueryFacet.class;
    }

    public JdoQueryFacetAbstract(@NonNull FacetHolder holder, @NonNull Can<Query> jdoNamedQueries) {
        super(JdoQueryFacetAbstract.type(), holder);
        if (holder == null) {
            throw new NullPointerException("holder is marked non-null but is null");
        }
        if (jdoNamedQueries == null) {
            throw new NullPointerException("jdoNamedQueries is marked non-null but is null");
        }
        ObjectSpecification objSpec = (ObjectSpecification)this.getFacetHolder();
        this.namedQueries = jdoNamedQueries.map(jdoNamedQuery -> new JdoNamedQuery(jdoNamedQuery, objSpec));
    }

    public void visitAttributes(BiConsumer<String, Object> visitor) {
        super.visitAttributes(visitor);
        visitor.accept("namedQueries", this.namedQueries);
    }

    public Can<JdoNamedQuery> getNamedQueries() {
        return this.namedQueries;
    }
}

