/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.query;

import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.commons.functional.Result;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelVisitingValidatorAbstract;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.query.JdoNamedQuery;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.query.JdoQueryFacet;

abstract class MetaModelVisitingValidatorForClauseAbstract
extends MetaModelVisitingValidatorAbstract {
    final String clause;

    protected MetaModelVisitingValidatorForClauseAbstract(MetaModelContext mmc, String clause) {
        super(mmc);
        this.clause = clause;
    }

    public void validate(ObjectSpecification objectSpec) {
        if (objectSpec.isManagedBean()) {
            return;
        }
        JdoQueryFacet jdoQueryFacet = (JdoQueryFacet)objectSpec.getFacet(JdoQueryFacet.class);
        if (jdoQueryFacet == null) {
            return;
        }
        for (JdoNamedQuery namedQuery : jdoQueryFacet.getNamedQueries()) {
            if (!namedQuery.getLanguage().equals("JDOQL")) continue;
            String query = namedQuery.getQuery();
            String fromClassName = this.deriveClause(query);
            this.interpretJdoql(fromClassName, objectSpec, query);
        }
    }

    private void interpretJdoql(String typeNameFromClause, ObjectSpecification objectSpec, String query) {
        if (_Strings.isNullOrEmpty((CharSequence)typeNameFromClause)) {
            return;
        }
        Class cls = objectSpec.getCorrespondingClass();
        Result fromSpecResult = Result.of(() -> this.getSpecificationLoader().specForType(_Context.loadClass((String)typeNameFromClause)).orElse(null));
        if (fromSpecResult.isFailure() || !fromSpecResult.getValue().isPresent()) {
            ValidationFailure.raise((SpecificationLoader)objectSpec.getSpecificationLoader(), (Identifier)Identifier.classIdentifier((LogicalType)LogicalType.fqcn((Class)cls)), (String)String.format("%s: error in JDOQL query, class name for '%s' clause not recognized (JDOQL : %s)", cls.getName(), this.clause, query));
            return;
        }
        this.postInterpretJdoql(typeNameFromClause, objectSpec, query);
    }

    abstract String deriveClause(String var1);

    abstract void postInterpretJdoql(String var1, ObjectSpecification var2, String var3);
}

