/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.query;

import java.util.Objects;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.functional.Result;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.Hierarchical;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.isis.persistence.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.isis.persistence.jdo.metamodel.facets.object.query.MetaModelVisitingValidatorForClauseAbstract;

class MetaModelVisitingValidatorForFromClause
extends MetaModelVisitingValidatorForClauseAbstract {
    MetaModelVisitingValidatorForFromClause(MetaModelContext mmc) {
        super(mmc, "FROM");
    }

    @Override
    String deriveClause(String query) {
        return JdoQueryAnnotationFacetFactory.from(query);
    }

    @Override
    void postInterpretJdoql(String classNameFromClause, ObjectSpecification objectSpec, String query) {
        String className = objectSpec.getCorrespondingClass().getName();
        if (Objects.equals(classNameFromClause, className)) {
            return;
        }
        Result fromSpecResult = Result.of(() -> this.getSpecificationLoader().specForType(_Context.loadClass((String)classNameFromClause)).orElse(null));
        if (fromSpecResult.isFailure() || !fromSpecResult.getValue().isPresent()) {
            ValidationFailure.raise((SpecificationLoader)objectSpec.getSpecificationLoader(), (Identifier)Identifier.classIdentifier((LogicalType)objectSpec.getLogicalType()), (String)String.format("%s: error in JDOQL query, logical type name after '%s' clause could not be loaded (JDOQL : %s)", className, this.clause, query));
            return;
        }
        ObjectSpecification fromSpec = (ObjectSpecification)fromSpecResult.getValue().get();
        Can subclasses = fromSpec.subclasses(Hierarchical.Depth.TRANSITIVE);
        if (subclasses.contains((Object)objectSpec)) {
            return;
        }
        ValidationFailure.raise((SpecificationLoader)objectSpec.getSpecificationLoader(), (Identifier)Identifier.classIdentifier((LogicalType)objectSpec.getLogicalType()), (String)String.format("%s: error in JDOQL query, type name after '%s' clause should be same as class name on which annotated, or one of its supertypes (JDOQL : %s)", className, this.clause, query));
    }
}

